/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void writeStackTraceIfNotNull(Throwable ex, OutputStream os) {
        if (os != null) {
            ExceptionUtils.writeStackTrace(ex, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStackTrace(Context ctx, Throwable ex, String filename) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(ctx.openFileOutput(filename, 0));
            ExceptionUtils.writeStackTrace(ex, writer);
        }
        catch (Exception e) {
            try {
                Fabric.getLogger().e("CrashlyticsCore", "Failed to create PrintWriter", (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeOrLog(writer, (String)"Failed to close stack trace writer.");
                throw throwable;
            }
            CommonUtils.closeOrLog((Closeable)writer, (String)"Failed to close stack trace writer.");
        }
        CommonUtils.closeOrLog((Closeable)writer, (String)"Failed to close stack trace writer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStackTrace(Throwable ex, OutputStream os) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(os);
            ExceptionUtils.writeStackTrace(ex, writer);
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Failed to create PrintWriter", (Throwable)e);
        }
        finally {
            CommonUtils.closeOrLog((Closeable)writer, (String)"Failed to close stack trace writer.");
        }
    }

    private static void writeStackTrace(Throwable ex, Writer writer) {
        try {
            boolean first = true;
            while (ex != null) {
                String message = ExceptionUtils.getMessage(ex);
                message = message != null ? message : "";
                String causedBy = first ? "" : "Caused by: ";
                writer.write(causedBy + ex.getClass().getName() + ": " + message + "\n");
                first = false;
                for (StackTraceElement element : ex.getStackTrace()) {
                    writer.write("\tat " + element.toString() + "\n");
                }
                ex = ex.getCause();
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e("CrashlyticsCore", "Could not write stack trace", (Throwable)e);
        }
    }

    private static String getMessage(Throwable t) {
        String message = t.getLocalizedMessage();
        if (message == null) {
            return null;
        }
        return message.replaceAll("(\r\n|\n|\f)", " ");
    }
}

