/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import com.crashlytics.android.core.ByteString;
import com.crashlytics.android.core.FileLogStore;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.QueueFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

class QueueFileLogStore
implements FileLogStore {
    private final File workingFile;
    private final int maxLogSize;
    private QueueFile logFile;

    public QueueFileLogStore(File workingFile, int maxLogSize) {
        this.workingFile = workingFile;
        this.maxLogSize = maxLogSize;
    }

    @Override
    public void writeToLog(long timestamp, String msg) {
        this.openLogFile();
        this.doWriteToLog(timestamp, msg);
    }

    @Override
    public ByteString getLogAsByteString() {
        if (!this.workingFile.exists()) {
            return null;
        }
        this.openLogFile();
        if (this.logFile == null) {
            return null;
        }
        final int[] offsetHolder = new int[]{0};
        final byte[] logBytes = new byte[this.logFile.usedBytes()];
        try {
            this.logFile.forEach(new QueueFile.ElementReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void read(InputStream in, int length) throws IOException {
                    try {
                        in.read(logBytes, offsetHolder[0], length);
                        offsetHolder[0] = offsetHolder[0] + length;
                    }
                    finally {
                        in.close();
                    }
                }
            });
        }
        catch (IOException e) {
            Fabric.getLogger().e("CrashlyticsCore", "A problem occurred while reading the Crashlytics log file.", (Throwable)e);
        }
        return ByteString.copyFrom(logBytes, 0, offsetHolder[0]);
    }

    @Override
    public void closeLogFile() {
        CommonUtils.closeOrLog((Closeable)this.logFile, (String)"There was a problem closing the Crashlytics log file.");
        this.logFile = null;
    }

    @Override
    public void deleteLogFile() {
        this.closeLogFile();
        this.workingFile.delete();
    }

    private void openLogFile() {
        if (this.logFile == null) {
            try {
                this.logFile = new QueueFile(this.workingFile);
            }
            catch (IOException e) {
                Fabric.getLogger().e("CrashlyticsCore", "Could not open log file: " + this.workingFile, (Throwable)e);
            }
        }
    }

    private void doWriteToLog(long timestamp, String msg) {
        if (this.logFile == null) {
            return;
        }
        if (msg == null) {
            msg = "null";
        }
        try {
            int quarterMaxLogSize = this.maxLogSize / 4;
            if (msg.length() > quarterMaxLogSize) {
                msg = "..." + msg.substring(msg.length() - quarterMaxLogSize);
            }
            msg = msg.replaceAll("\r", " ");
            msg = msg.replaceAll("\n", " ");
            byte[] msgBytes = String.format(Locale.US, "%d %s%n", timestamp, msg).getBytes("UTF-8");
            this.logFile.add(msgBytes);
            while (!this.logFile.isEmpty() && this.logFile.usedBytes() > this.maxLogSize) {
                this.logFile.remove();
            }
        }
        catch (IOException e) {
            Fabric.getLogger().e("CrashlyticsCore", "There was a problem writing to the Crashlytics log.", (Throwable)e);
        }
    }
}

