/**
 * A Java program to demonstrate the side effects that could be
 * happening in a method execution if it depends on the variables
 * other than the input arguments.
 *
 * This class has a method named modifyValue() that accepts an 
 * input parameter which it will be modifying based on the other
 * variable called 'count' which is an instance level variable
 *
 * From the main() method, this modifyValue() is called 3 times with
 * the same input value (1) but the output is different everytime 
 * because the instance variable count is increased within the 
 * modifyValue() method everytime it is invoked.
 *
 * Hence, this method modifyValue() is proven to have a side effect,
 * which is something else other than the intended purpose of method
 * execution (which is incrementing the count variable's value thereby
 * affecting the result of method execution eventhough the same input
 * is passed for every invocation).
 *
 * Author : Raghavan alias Saravanan M (JavaCodeGeeks)
 * Date   : 07 May 2016
 */
public class SideEffect
{
	int count = 0;

	public static void main(String... args)
	{
		int x = 1;
		int modifiedValue = -1;

		SideEffect obj = new SideEffect();

		for(int i=1; i<=3; i++) 
		{
			modifiedValue  = obj.modifyValue(x);
			System.out.println("Input : " + x + ", Modified : " + modifiedValue);
		}
	}

	public int modifyValue(int x)
	{
		this.count++;
		return x + count;	
	}
}
