import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class FxHtmlEditorExample2 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the HTMLEditor
		HTMLEditor htmlEditor = new HTMLEditor();
        // Set the Height of the HTMLEditor
		htmlEditor.setPrefHeight(300);
        // Set the Width of the HTMLEditor
		htmlEditor.setPrefWidth(600);

        // Create the Scene
        Scene scene = new Scene(htmlEditor);
		// Add the Scene to the Stage
        stage.setScene(scene);
		// Add the Stylesheet to the Scene
		scene.getStylesheets().add(getClass().getResource("htmleditor.css").toExternalForm());
		// Set the Title of the Stage
		stage.setTitle("A HTMLEditor Example with a Stylesheet");
		// Display the Stage
        stage.show();
	}
}
