import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class FxHtmlEditorExample3 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the HTMLEditor
		HTMLEditor htmlEditor = new HTMLEditor();
        // Set the Height of the HTMLEditor
		htmlEditor.setPrefHeight(300);
        // Set the Width of the HTMLEditor
		htmlEditor.setPrefWidth(600);

		// Set the Initial Text
        String INITIAL_TEXT =
			"An HTMLEditor displays formatting toolbars with it. "
	        + "Using the toolbars, you can: </br></br>"
	        + "<ul><li>Copy, cut, and paste text using the system clipboard</li>"
	        + "<li>Apply text alignment</li>"
	        + "<li>Indent text</li>"
	        + "<li>Apply bulleted list and numbered list styles</li>"
	        + "<li>Set foreground and background colors</li>"
	        + "<li>Apply paragraph and heading styles with font family and font size</li>"
	        + "<li>Apply formatting styles such as bold, italic, underline, and strikethrough</li>"
	        + "<li>Add horizontal rulers</li></ul>";

        htmlEditor.setHtmlText(INITIAL_TEXT);

        // Create the Scene
        Scene scene = new Scene(htmlEditor);
		// Add the Scene to the Stage
        stage.setScene(scene);
		// Add the Stylesheet to the Scene
		scene.getStylesheets().add(getClass().getResource("htmleditor.css").toExternalForm());
		// Set the Title of the Stage
		stage.setTitle("A HTMLEditor Example with an Initial Text");
		// Display the Stage
        stage.show();
    }
}
