import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class FxHtmlEditorExample4 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the HTMLEditor
		final HTMLEditor htmlEditor = new HTMLEditor();
        // Set the Height of the HTMLEditor
		htmlEditor.setPrefHeight(300);
        // Set the Width of the HTMLEditor
		htmlEditor.setPrefWidth(600);
		// Set the Initial Text
        htmlEditor.setHtmlText("");

        // Create the TextArea
		final TextArea textArea = new TextArea();
		// Set the Size of the TextArea
		textArea.setPrefSize(600, 300);
		// Set the Style of the TextArea
		textArea.setStyle("-fx-font-size:10pt; -fx-font-family: \"Courier New\";");

        // Create the Buttons
		Button htmlToText = new Button("Convert HTML to Text");
		Button textToHtml = new Button("Convert Text to HTML");

        // Define the Actions for the Buttons
		htmlToText.setOnAction(new EventHandler<ActionEvent>()
        {
            @Override public void handle(ActionEvent arg0)
            {
            	htmlEditor.setHtmlText(textArea.getText());
            }
        });

		textToHtml.setOnAction(new EventHandler<ActionEvent>()
        {
            @Override public void handle(ActionEvent arg0)
            {
            	textArea.setText(htmlEditor.getHtmlText());
            }
        });

		// Create the HBox for the Buttons
		HBox buttons = new HBox(htmlToText, textToHtml);
		// Set Spacing to the HBox
		buttons.setSpacing(10);

        // Create the VBox
        VBox root = new VBox();
        // Set the Padding of the VBox
        root.setPadding(new Insets(8, 8, 8, 8));
        // Set Spacing to 5 px
        root.setSpacing(5);
        // Set the Position of the VBox
        root.setAlignment(Pos.BOTTOM_LEFT);
		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
			"-fx-border-style: solid inside;" +
			"-fx-border-width: 2;" +
			"-fx-border-insets: 5;" +
			"-fx-border-radius: 5;" +
			"-fx-border-color: blue;");

		// Add the Children to The VBox
        root.getChildren().addAll(htmlEditor, buttons, textArea);

        // Create the Scene
        Scene scene = new Scene(root);
		// Add the Stylesheet to the Scene
		scene.getStylesheets().add(getClass().getResource("htmleditor.css").toExternalForm());
		// Add the Scene to the Stage
        stage.setScene(scene);
        // Set the Width and Heigth of the Stage
        stage.setWidth(500);
        stage.setHeight(500);
		// Set the Title of the Stage
		stage.setTitle("A HTMLEditor Converter Example");
		// Display the Stage
        stage.show();
 }
}
