import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

public class FxTransformationExample1 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Rectangles
		Rectangle rectangle1 = new Rectangle(100, 50, Color.LIGHTGRAY);
		rectangle1.setStroke(Color.BLACK);
		Rectangle rectangle2 = new Rectangle(100, 100, Color.YELLOW);
		rectangle2.setStroke(Color.BLACK);
		Rectangle rectangle3 = new Rectangle(180, 100, Color.STEELBLUE);
		rectangle3.setStroke(Color.BLACK);

		// Apply a Translation on Rectangle1 using the transforms sequence
		Translate translate1 = new Translate(50, 40);
		rectangle1.getTransforms().addAll(translate1);

		// Apply a Translation on Rectangle2 using the transforms sequence
		Translate translate2 = new Translate(100, 80);
		rectangle2.getTransforms().addAll(translate2);

		// Apply a Translation on Rectangle3 using the translateX and translateY proeprties
		rectangle3.setTranslateX(180);
		rectangle3.setTranslateY(70);

		// Create the Pane
		Pane root = new Pane(rectangle1, rectangle2, rectangle3);
		// Set the size of the Pane
		root.setPrefSize(400, 300);
		// Set the Style-properties of the Pane
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the title of the Stage
		stage.setTitle("A Translation Transformation Example");
		// Display the Stage
		stage.show();
	}
}
