import javafx.application.Application;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class FxSceneExample1 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Image
		String file = "file:///C:/Workspaces/workspace_java/JavaFXProjects/src/FXScene/javafx-logo.png";
		Image image = new Image(file);

		// Create the Cursor
		Cursor myCur = Cursor.cursor(file);

		// Create the ImageView
		ImageView imageView = new ImageView();

		// Add the Image to the ImageView
        imageView.setImage(image);

        // Create the VBox
		VBox root = new VBox();

		// Set the width and height of the VBox
		root.setMinWidth(300);
		root.setMinHeight(200);

		// Add the ImageView to the VBox
		root.getChildren().add(imageView);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Set the Cursor to the Scene
		scene.setCursor(myCur);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("Setting the Cursor for a Scene");
		// Display the Stage
		stage.show();
	}

}
