import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class FxSceneExample2 extends Application
{
	// Create the TextArea
	TextArea textarea = new TextArea();

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Button
		Button button = new Button("Test");

		// Create the VBox
		VBox root = new VBox();

		// Set the width and height of the VBox
		root.setMinWidth(200);
		root.setMinHeight(100);

		// Add the children to the VBox
		root.getChildren().addAll(button, textarea);

		// Set the Focus Owner
		button.requestFocus();

		// Create the Scene
		Scene scene = new Scene(root);

		// Get the FocusOwner
		Node focusOwnerNode = scene.getFocusOwner();

		if (focusOwnerNode == null)
		{
			// The scene does not have a focus owner
			writeMessage("The scene does not have a focus owner");
		}
		else if (focusOwnerNode.isFocused())
		{
			// The focus owner is the one that has the focus
			writeMessage("The focus owner is the one that has the focus");
		}
		else
		{
			// The focus owner does not have the focus
			writeMessage("The focus owner does not have the focus");
		}

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("Testing the Focus Owner in a Scene");
		// Display the Stage
		stage.show();
	}

	private void writeMessage(String msg)
	{
		textarea.appendText(msg + "\n");
	}
}
