import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderPaneBuilder;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.stage.Stage;

public class FxSceneExample3 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the first Rectangle
		Rectangle rectangle1 = RectangleBuilder.create()
				.x(10)
				.y(20)
				.width(200)
				.height(100)
				.fill(Color.RED)
				.build();

		// Create a partially configured RectangleBuilder
		@SuppressWarnings("rawtypes")
		RectangleBuilder builder = RectangleBuilder.create()
		.width(50)
		.height(50)
		.fill(Color.GREEN);

		// Create additional Rectangles using the Builder
		Rectangle rectangle2 = builder.x(250).y(50).build();
		Rectangle rectangle3 = builder.x(350).y(80).build();

		// Create the BorderPane
		BorderPane root = BorderPaneBuilder.create().build();
		// Set the Size of the BorderPane
		root.setMinWidth(500);
		root.setMinHeight(200);

		// ASdd the Children to the Group
		root.getChildren().addAll(rectangle1, rectangle2, rectangle3);

		// Set the Style-properties of the BorderPane
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("An example with Builder Classes");
		// Display the Stage
		stage.show();
	}

}
