import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.LabelBuilder;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Stage;

public class FxSceneExample4 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the whole Scene using different SceneBuilder Classes
		Scene scene = SceneBuilder.create().width(300).height(100).root
		(
			VBoxBuilder.create().minWidth(300).minHeight(200).children(
			LabelBuilder.create().text("Hello Builder").build(),
			ButtonBuilder.create().text("Exit").onAction(new EventHandler<ActionEvent>()
			{
				@Override
				public void handle(ActionEvent event)
				{
					System.exit(0);
				}
			}
			).build()
		).build()).build();

		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("Another example with Builder Classes");
		// Display the Stage
		stage.show();
	}

}
