import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class FxSceneExample5 extends Application
{
	// Create the TextArea
	TextArea textarea = new TextArea();

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void init()
	{
		writeMessage("init(): " + Thread.currentThread().getName() + "\n");

		// Create a Runnable task
		Runnable task = new Runnable()
		{
			public void run()
			{
				writeMessage("Running the task on the " + Thread.currentThread().getName());
			}
		};

		// Submit the task to be run on the JavaFX Application Thread
		Platform.runLater(task);
	}

	@Override
	public void start(Stage stage) throws Exception
	{
		// Create the BorderPane
		VBox root = new VBox();

		// Set the Style-properties of the VBOx
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Add the TextArea to the Group
		root.getChildren().add(textarea);

		// Create the Scene
		Scene scene = new Scene(root);

		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Platform Example");
		// Display the Stage
		stage.show();
	}

	private void writeMessage(String msg)
	{
		textarea.appendText(msg + "\n");
	}

}
