import java.util.HashMap;
import java.util.Map;

import javafx.application.Application;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import netscape.javascript.JSObject;

public class FxSceneExample6 extends Application
{
	// Create the TextArea
	TextArea textarea = new TextArea();

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the URL-String
		final String yahooURL = "http://www.yahoo.com";

		// Create the Buttons and their EventHandlers
		Button openURLButton = new Button("Go to Yahoo!");

		openURLButton.setOnAction(new EventHandler<ActionEvent>()
		{
			@Override
			public void handle(ActionEvent event)
			{
				getHostServices().showDocument(yahooURL);
			}
		});

		Button showAlert = new Button("Show Alert");

		showAlert.setOnAction(new EventHandler<ActionEvent>()
		{
			@Override
			public void handle(ActionEvent event)
			{
				showAlert();
			}
		});

		// Create the HBox
		HBox hbox = new HBox();
		// Add the Children to the HBox
		hbox.getChildren().addAll(openURLButton, showAlert);

		// Create the VBox
		VBox root = new VBox();

		// Set the width and height of the VBox
		root.setMinWidth(400);
		root.setMinHeight(300);

		// Add buttons and all host related details to the VBox
		root.getChildren().addAll(hbox,textarea);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Map
		Map<String, String> hostdetails = getHostDetails();

		// Add the Details to the Map
		for(Map.Entry<String, String> entry : hostdetails.entrySet())
		{
			String desc = entry.getKey() + ": " + entry.getValue();
			textarea.appendText(desc + "\n");
		}

		// Create the Scene
		Scene scene = new Scene(root);

		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("Knowing the Host");
		// Display the Stage
		stage.show();
	}

	protected Map<String, String> getHostDetails()
	{
		// Create the Map
		Map<String, String> map = new HashMap<>();

		// Create the Host
		HostServices host = this.getHostServices();

		// Get the Host Details
		String codeBase = host.getCodeBase();
		map.put("CodeBase", codeBase);

		String documentBase = host.getDocumentBase();
		map.put("DocumentBase", documentBase);

		JSObject js = host.getWebContext();
		map.put("Environment", js == null?"Non-Web":"Web");

		String splashImageURI = host.resolveURI(documentBase, "splash.jpg");
		map.put("Splash Image URI", splashImageURI);

		return map;
	}

	protected void showAlert()
	{
		// CReate the Host
		HostServices host = getHostServices();

		// Create a JavaScriptObject
		JSObject js = host.getWebContext();

		if (js == null)
		{
			// Create the Stage
			Stage stage = new Stage(StageStyle.UTILITY);
			stage.initModality(Modality.WINDOW_MODAL);

			// Create the Label
			Label label = new Label("This is an FX alert!");

			// create the VBox
			VBox root = new VBox();

			// Set the width and height of the VBox
			root.setMinWidth(300);
			root.setMinHeight(200);

			// Set the Style-properties of the VBox
			root.setStyle("-fx-padding: 10;" +
					"-fx-border-style: solid inside;" +
					"-fx-border-width: 2;" +
					"-fx-border-insets: 5;" +
					"-fx-border-radius: 5;" +
					"-fx-border-color: blue;");

			// Add the Children to the VBox
			root.getChildren().add(label);

			// Create the Scene
			Scene scene = new Scene(root);

			// Add the Scene to the Stage
			stage.setScene(scene);

			// Set the Title of the Stage
			stage.setTitle("FX Alert");

			//Display the Stage
			stage.show();
		}
		else
		{
			js.eval("window.alert('This is a JavaScript alert!')");
		}
	}
}
