import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class FxEventExample1 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create a coral Circle
		Circle circle = new Circle (150, 150, 50);
		circle.setFill(Color.CORAL);

		// Create a MouseEvent filter
		EventHandler<MouseEvent> mouseEventFilter = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	writelog("Mouse event filter has been called");
            }
        };

		// Create a MouseEvent handler
		EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	writelog("Mouse event handler has been called");
            }
        };

		// Register the MouseEvent filter and handler to the Circle for mouse-clicked events
		circle.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEventFilter);
		circle.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEventHandler);

		// Create the VBox
		VBox root = new VBox();
		// Add the children to the VBox
		root.getChildren().addAll(circle, loggingArea);

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root, 400,300);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("An Example about Registering Event Filters and Handlers");
		// Display the Stage
		stage.show();
	}

	// Helper Method for Logging
	private void writelog(String text)
	{
		this.loggingArea.appendText(text + "\n");
	}

}
