import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class FxEventExample2 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create a coral Circle
		Circle circle = new Circle (150, 150, 50);
		circle.setFill(Color.CORAL);

		// Create the VBox
		VBox root = new VBox();
		// Add the children to the VBox
		root.getChildren().addAll(circle, loggingArea);

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);

		// Register three handlers for the circle that can handle mouse-clicked events //
		// This will be called last
		circle.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleAnyMouseEvent(event);
            }
        });

		// This will be called first
		circle.addEventHandler(MouseEvent.MOUSE_CLICKED,  new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleMouseClicked("addEventHandler()", event);
            }
        });

		// This will be called second
		circle.setOnMouseClicked(new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleMouseClicked("setOnMouseClicked()", event);
            }
        });

		// Add the Stage to the Scene
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("An Example about the Execution Order of Events");
		// Display the Stage
		stage.show();
	}

	public void handleMouseClicked(String registrationMethod, MouseEvent e)
	{
		// Print a message for a mouse click
		this.loggingArea.appendText(registrationMethod
			+ ": MOUSE_CLICKED handler detected a mouse click.\n");
	}

	public void handleAnyMouseEvent(MouseEvent e)
	{
		// Print a message only for mouse-clicked events, ignoring
		// other mouse events such as mouse-pressed, mouse-released, etc.
		if (e.getEventType() == MouseEvent.MOUSE_CLICKED)
		{
			this.loggingArea.appendText("MouseEvent.ANY handler detected a mouse click.\n");
		}
	}
}
