import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import static javafx.scene.input.MouseEvent.MOUSE_CLICKED;
import javafx.scene.control.TextArea;

public class FxEventExample3 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create a Circle
		Circle circle = new Circle (50, 50, 50);
		circle.setFill(Color.CORAL);

		// Create a Rectangle
		Rectangle rectangle = new Rectangle(100, 100);
		rectangle.setFill(Color.TAN);

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing of the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);

		// Add the children to the HBox
		hbox.getChildren().addAll(circle, rectangle);

		// CReate the VBox
		VBox root = new VBox();
		// Set Padding and Spacing of the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);

		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Create the Scene
		Scene scene = new Scene(root);

		// Create two EventHandlders
		EventHandler<MouseEvent> filter = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleEvent("Capture",event);
            }
        };

		EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleEvent("Bubbling",event);
            }
        };

		// Register the Event Filters
		stage.addEventFilter(MOUSE_CLICKED, filter);
		scene.addEventFilter(MOUSE_CLICKED, filter);
		root.addEventFilter(MOUSE_CLICKED, filter);
		circle.addEventFilter(MOUSE_CLICKED, filter);

		// Register the Event Handlers
		stage.addEventHandler(MOUSE_CLICKED, handler);
		scene.addEventHandler(MOUSE_CLICKED, handler);
		root.addEventHandler(MOUSE_CLICKED, handler);
		circle.addEventHandler(MOUSE_CLICKED, handler);

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("An Example about Event Capture and Bubbling");
		// Display the Stage
		stage.show();
	}

	// Helper Method for Event-Handling
	public void handleEvent(String phase, MouseEvent e)
	{
		// Get type, source and target of the Event
		String type = e.getEventType().getName();
		String source = e.getSource().getClass().getSimpleName();
		String target = e.getTarget().getClass().getSimpleName();

		// Get coordinates of the mouse cursor relative to the Event Source
		double x = e.getX();
		double y = e.getY();

		// Log the Informations
		this.loggingArea.appendText(phase + ": Type=" + type +
			", Target=" + target + ", Source=" + source +
			", location(" + x + ", " + y + ")\n");
	}

}
