import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxInputEventExample1 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Circle
		Circle circle = new Circle (50, 50, 50);
		circle.setFill(Color.CORAL);

		// Create the Rectangle
		Rectangle rect = new Rectangle(100, 100);
		rect.setFill(Color.TAN);

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing for the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);
		// Add the children to the HBox
		hbox.getChildren().addAll(circle, rect);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Add a MOUSE_CLICKED event handler to the stage
		stage.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleMouseMove(event);
            }
        });

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Mouse Location Example");
		// Display the Stage
		stage.show();
	}

	public void handleMouseMove(MouseEvent e)
	{
		// Get the source and target of the Event
		String source = e.getSource().getClass().getSimpleName();
		String target = e.getTarget().getClass().getSimpleName();

		// Get the Mouse location relative to the event source
		double sourceX = e.getX();
		double sourceY = e.getY();

		// Get the Mouse location relative to the scene
		double sceneX = e.getSceneX();
		double sceneY = e.getSceneY();

		// Get the Mouse location relative to the screen
		double screenX = e.getScreenX();
		double screenY = e.getScreenY();

		// Log the Informations
		this.loggingArea.appendText
		(
			"Source=" + source + ", Target=" + target +
			", Location:" + " source(" + sourceX + ", " + sourceY + ")" +
			", scene(" + sceneX + ", " + sceneY + ")" +
			", screen(" + screenX + ", " + screenY + ")\n"
		);
	}
}
