import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxInputEventExample2 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");
	// Create the CheckBox
	private CheckBox checkbox = new CheckBox("Pick on Bounds");
	// Create the Circle
	private Circle circle = new Circle(50, 50, 50, Color.LIGHTGRAY);

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Rectangle
		Rectangle rectangle = new Rectangle(100, 100);
		rectangle.setFill(Color.RED);

		// Create the Group
		Group group = new Group();
		// Add the children to the Group
		group.getChildren().addAll(rectangle, circle);

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing for the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);
		// Add the children to the HBox
		hbox.getChildren().addAll(group, checkbox);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Add MOUSE_CLICKED event handlers to the Circle
		circle.setOnMouseClicked(new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleMouseClicked(event);
            }
        });

		// Add MOUSE_CLICKED event handlers to the Rectangle
		rectangle.setOnMouseClicked(new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleMouseClicked(event);
            }
        });

		// Add an Action handler to the CheckBox
		checkbox.setOnAction(new EventHandler<ActionEvent>()
		{
			@Override
			public void handle(ActionEvent event)
			{
				handleActionEvent(event);
			}
		});

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Pick on Bounds Example");
		// Display the Stage
		stage.show();
	}

	public void handleMouseClicked(MouseEvent e)
	{
		// Get the source and type of the Event
		String target = e.getTarget().getClass().getSimpleName();
		String type = e.getEventType().getName();

		// Log the Informations
		this.loggingArea.appendText(type + " on " + target + "\n");
	}

	public void handleActionEvent(ActionEvent e)
	{
		if (checkbox.isSelected())
		{
			circle.setPickOnBounds(true);
		}
		else
		{
			circle.setPickOnBounds(false);
		}
	}
}
