import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class FxInputEventExample4 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Circle
		Circle circle = new Circle (50, 50, 50);
		circle.setFill(Color.GRAY);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(circle, loggingArea);

		// Create a Mouse Event handler
		EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	// Get the Type, Source and Target of the Event
            	String type = event.getEventType().getName();
        		String source = event.getSource().getClass().getSimpleName();
        		String target = event.getTarget().getClass().getSimpleName();

        		// Log the informations
        		loggingArea.appendText( "Type=" + type + ", Target=" + target +
        			", Source=" + source + "\n");
            }
        };

		// Add mouse-entered and mouse-exited event handlers to the VBox
		root.addEventHandler(MouseEvent.MOUSE_ENTERED, handler);
		root.addEventHandler(MouseEvent.MOUSE_EXITED, handler);

		// Add mouse-entered and mouse-exited event handlers to the Circle
		circle.addEventHandler(MouseEvent.MOUSE_ENTERED, handler);
		circle.addEventHandler(MouseEvent.MOUSE_EXITED, handler);

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the stage
		stage.setTitle("An Example of Mouse Entered and Exited Events");
		// Display the Stage
		stage.show();
	}
}
