import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class FxInputEventExample5 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");
	// Create the CheckBox
	private CheckBox checkbox = new CheckBox("Consume Events");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Circle
		Circle circle = new Circle (50, 50, 50);
		circle.setFill(Color.GRAY);

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing for the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);
		// Add the children to the HBox
		hbox.getChildren().addAll(circle, checkbox);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Create mouse event handlers
		EventHandler<MouseEvent> circleHandler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleCircle(event);
            }
        };

        EventHandler<MouseEvent> circleTargetHandler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleCircleTarget(event);
            }
        };

		EventHandler<MouseEvent> hBoxTargetHandler = new EventHandler<MouseEvent>()
		{
            public void handle(MouseEvent event)
            {
            	handleHBoxTarget(event);
            }
        };

		// Add mouse-entered-target and mouse-exited-target event handlers to VBox
		root.addEventFilter(MouseEvent.MOUSE_ENTERED_TARGET, hBoxTargetHandler);
		root.addEventFilter(MouseEvent.MOUSE_EXITED_TARGET, hBoxTargetHandler);

		// Add mouse-entered-target and mouse-exited-target event handlers to the Circle
		circle.addEventHandler(MouseEvent.MOUSE_ENTERED_TARGET, circleTargetHandler);
		circle.addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, circleTargetHandler);

		// Add mouse-entered and mouse-exited event handlers to the Circle
		circle.addEventHandler(MouseEvent.MOUSE_ENTERED, circleHandler);
		circle.addEventHandler(MouseEvent.MOUSE_EXITED, circleHandler);

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Mouse Entered and Exited Target Events Example");
		// Display the Stage
		stage.show();
	}

	// Helper Methods for Event Handling
	public void handleCircle(MouseEvent e)
	{
		print(e, "Circle Handler");
	}

	public void handleCircleTarget(MouseEvent e)
	{
		print(e, "Circle Target Handler");
	}

	public void handleHBoxTarget(MouseEvent e)
	{
		print(e, "HBox Target Filter");

		if (checkbox.isSelected())
		{
			e.consume();
			this.loggingArea.appendText("HBox consumed the " + e.getEventType() + " event\n");
		}
	}

	public void print(MouseEvent e, String msg)
	{
		// Get the Type, Source and Target of the Event
		String type = e.getEventType().getName();
		String source = e.getSource().getClass().getSimpleName();
		String target = e.getTarget().getClass().getSimpleName();

		// Log the Informations
		this.loggingArea.appendText(msg + ": Type=" + type + ", "
			+ "Target=" + target + 	", Source=" + source + "\n");
	}
}
