import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class FxInputEventExample7 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the Label
		Label label = new Label("Name:");
		// Create the TextField
		TextField textfield = new TextField();

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing for the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);
		// Add the children to the HBox
		hbox.getChildren().addAll(label, textfield);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Add key pressed and released events to the TextField
		textfield.setOnKeyTyped(new EventHandler<KeyEvent>()
		{
            public void handle(final KeyEvent keyEvent)
            {
            	handleEvent(keyEvent);
            }
        });

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Key Typed Event Example");
		// Display the Stage
		stage.show();
	}

	public void handleEvent(KeyEvent e)
	{
		// Consume the event if it is not a letter
		String str = e.getCharacter();

		int len = str.length();

		for(int i = 0; i < len; i++)
		{
			Character c = str.charAt(i);
			if (!Character.isLetter(c))
			{
				e.consume();
			}
		}

		// Print the details if it is not consumed
		if (!e.isConsumed())
		{
			String type = e.getEventType().getName();
			this.loggingArea.appendText(type + ": Character=" + e.getCharacter() + "\n");
		}
	}
}
