import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class FxInputEventExample8 extends Application
{
	// Create the LoggingArea
	private TextArea loggingArea = new TextArea("");
	// Create the CheckBox
	private CheckBox checkbox = new CheckBox("Can Close Window");

	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(final Stage stage)
	{
		// Create the Buttons
		Button closeButton = new Button("Close");
		Button hideButton = new Button("Hide");

		// Add the Event Handlers to the Buttons
		closeButton.setOnAction(new EventHandler<ActionEvent>()
		{
            public void handle(ActionEvent event)
            {
            	stage.close();
            }
        });

		hideButton.setOnAction(new EventHandler<ActionEvent>()
		{
            public void handle(ActionEvent event)
            {
            	showDialog(stage);
            	stage.hide();
            }
        });

		// Create the HBox
		HBox hbox = new HBox();
		// Set Padding and Spacing for the HBox
		hbox.setPadding(new Insets(20));
		hbox.setSpacing(20);
		// Add the children to the HBox
		hbox.getChildren().addAll(checkbox, closeButton, hideButton);

		// Create the VBox
		VBox root = new VBox();
		// Set Padding and Spacing for the VBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the VBox
		root.getChildren().addAll(hbox, loggingArea);

		// Add window event handlers to the Stage
		stage.setOnShowing(new EventHandler<WindowEvent>()
		{
            public void handle(WindowEvent event)
            {
            	handleEvent(event);
            }
        });

		stage.setOnShown(new EventHandler<WindowEvent>()
		{
            public void handle(WindowEvent event)
            {
            	handleEvent(event);
            }
        });

		stage.setOnHiding(new EventHandler<WindowEvent>()
		{
            public void handle(WindowEvent event)
            {
            	handleEvent(event);
            }
        });

		stage.setOnHidden(new EventHandler<WindowEvent>()
		{
            public void handle(WindowEvent event)
            {
            	handleEvent(event);
            }
        });

		stage.setOnCloseRequest(new EventHandler<WindowEvent>()
		{
            public void handle(WindowEvent event)
            {
            	handleEvent(event);
            }
        });

		// Set the Padding and Border for the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("Window Events");
		// Display the Stage
		stage.show();
	}

	public void handleEvent(WindowEvent e)
	{
		// Consume the event if the CheckBox is not selected
		// thus preventing the user from closing the window
		EventType<WindowEvent> type = (EventType<WindowEvent>) e.getEventType();

		if (type == WindowEvent.WINDOW_CLOSE_REQUEST && !checkbox.isSelected())
		{
			e.consume();
		}

		// Log the Information
		this.loggingArea.appendText(type + ": Consumed=" + e.isConsumed() + "\n");
	}

	public void showDialog(final Stage mainWindow)
	{
		// Create the Stage
		final Stage popup = new Stage();

		// CReate the Button
		Button closeButton = new Button("A Click to Show Main Window Example");
		// Add the Event Handler to the Button
		closeButton.setOnAction(new EventHandler<ActionEvent>()
		{
            public void handle(ActionEvent event)
            {
            	popup.close();
            	mainWindow.show();
            }
        });

		// Create the HBox
		HBox root = new HBox();
		// Set Padding and Spacing for the HBox
		root.setPadding(new Insets(20));
		root.setSpacing(20);
		// Add the children to the HBox
		root.getChildren().addAll(closeButton);

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		popup.setScene(scene);
		// Set the Title of the STage
		popup.setTitle("Popup");
		// Display the Stage
		popup.show();
	}
}
