import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.stage.Stage;

public class FxComplexShapeExample3 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(final Stage stage)
	{
		// Create the PathElements

		// Both triangles use a counterclockwise stroke
		PathElement[] pathEleemnts1 = {new MoveTo(50, 0),
			new LineTo(0, 50),
			new LineTo(100, 50),
			new LineTo(50, 0),
			new MoveTo(90, 15),
			new LineTo(40, 65),
			new LineTo(140, 65),
			new LineTo(90, 15)};

		// One Triangle uses a clockwise stroke and
		// another uses a counterclockwise stroke
		PathElement[] pathEleemnts2 = {new MoveTo(50, 0),
			new LineTo(0, 50),
			new LineTo(100, 50),
			new LineTo(50, 0),
			new MoveTo(90, 15),
			new LineTo(140, 65),
			new LineTo(40, 65),
			new LineTo(90, 15)};

		// Create the Path

		/* Using the NON-ZERO fill rule by default */
		Path path1 = new Path(pathEleemnts1);
		path1.setFill(Color.LIGHTGRAY);

		Path path2 = new Path(pathEleemnts2);
		path2.setFill(Color.LIGHTGRAY);

		/* Using the EVEN_ODD fill rule */
		Path path3 = new Path(pathEleemnts1);
		path3.setFill(Color.LIGHTGRAY);
		path3.setFillRule(FillRule.EVEN_ODD);

		Path path4 = new Path(pathEleemnts2);
		path4.setFill(Color.LIGHTGRAY);
		path4.setFillRule(FillRule.EVEN_ODD);

		// Create the HBox
		HBox root = new HBox(path1, path2, path3, path4);
		root.setSpacing(10);

		// Set the Style of the HBox
		root.setStyle("-fx-padding: 10;" +
			"-fx-border-style: solid inside;" +
			"-fx-border-width: 2;" +
			"-fx-border-insets: 5;" +
			"-fx-border-radius: 5;" +
			"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Fill Rule Example");
		// Display the Stage
		stage.show();
	}
}
