import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.stage.Stage;

public class FxComplexShapeExample5 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(final Stage stage)
	{
		// Create the Rectangles
		Rectangle rectangle1 = new Rectangle(50, 50);
		rectangle1.setFill(Color.LIGHTGRAY);

		Rectangle rectangle2 = new Rectangle(50, 50);
		rectangle2.setFill(Color.LIGHTGRAY);
		rectangle2.setStroke(Color.BLACK);
		rectangle2.setStrokeWidth(4);
		rectangle2.setStrokeType(StrokeType.INSIDE);

		Rectangle rectangle3 = new Rectangle(50, 50);
		rectangle3.setFill(Color.LIGHTGRAY);
		rectangle3.setStroke(Color.BLACK);
		rectangle3.setStrokeWidth(4);

		Rectangle rectangle4 = new Rectangle(50, 50);
		rectangle4.setFill(Color.LIGHTGRAY);
		rectangle4.setStroke(Color.BLACK);
		rectangle4.setStrokeWidth(4);
		rectangle4.setStrokeType(StrokeType.OUTSIDE);

		// Create the HBox
		HBox root = new HBox(rectangle1, rectangle2, rectangle3, rectangle4);
		root.setAlignment(Pos.CENTER);
		root.setSpacing(10);

		// Set the Style of the HBox
		root.setStyle("-fx-padding: 10;" +
			"-fx-border-style: solid inside;" +
			"-fx-border-width: 2;" +
			"-fx-border-insets: 5;" +
			"-fx-border-radius: 5;" +
			"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root);
		// Add the Scene to the Stage
		stage.setScene(scene);
		// Set the Title of the Stage
		stage.setTitle("A Stroke Type Example");
		// Display the Stage
		stage.show();
	}
}
