package com.javacodegeeks.example;

import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateInsertProgram {
	private static SessionFactory factory;
	private static ServiceRegistry serviceRegistry;

	@SuppressWarnings("deprecation")
	public static void main(String[] args) 
	{
		addAllConfigs();
		
		HibernateInsertProgram hi = new HibernateInsertProgram();
		long one = hi.insertStudent(1," Mark Johnson", 58, new Date("08/11/2008"));
		long two = hi.insertStudent(2, "Jill Rhodes", 95, new Date("08/08/2008"));
		
		System.out.println(" We successfully inserted students in student table...they are..." + one + " and " + two);
	}
	
	public static void addAllConfigs()
	{
		Configuration config = new Configuration();
		config.configure();
		config.addAnnotatedClass(Student.class);
		config.addResource("Student.hbm.xml");
		serviceRegistry = new StandardServiceRegistryBuilder().applySettings(config.getProperties()).build();
		factory = config.buildSessionFactory(serviceRegistry);
	}

	private long insertStudent(int id, String name, int marks, Date joindate)
	{
		Session session = factory.openSession();
		Transaction tx = null;
		Integer stId = null;
		try
		{
			tx = session.beginTransaction();
			Student st = new Student();
			st.setSid(id);
			st.setStudent_name(name);
			st.setStudent_marks(marks);
			st.setStudentjoin_date(joindate);
			
			stId = (Integer) session.save(st);
			tx.commit();
		} 
		catch (HibernateException ex)
		{
			if(tx != null)
				tx.rollback();
		}
		finally
		{
			session.close();
		}
		
		return stId;
	}
}
