package com.javacodegeeks.example;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateTestProgram {

	private static SessionFactory factory;
	private static ServiceRegistry serviceRegistry;
	
	public static void main(String[] args) 
	{
		// TODO Auto-generated method stub
		
	        Configuration config = new Configuration();
			config.configure();
			config.addAnnotatedClass(Department.class);
			config.addResource("Department.hbm.xml");
			config.addAnnotatedClass(Employee.class);
			config.addResource("Employee.hbm.xml");
			
			serviceRegistry = new StandardServiceRegistryBuilder().applySettings(config.getProperties()).build();
			factory = config.buildSessionFactory(serviceRegistry);
			HibernateTestProgram hbp = new HibernateTestProgram();
			
			List<Employee> marketingEmployees = hbp.readMarketingEmployees();
			System.out.println(" List of Employees from Marketing Department are : " );
			for(int i = 0; i < marketingEmployees.size(); i++)
			{
				Employee e = marketingEmployees.get(i);
				System.out.println(e.getFirstname() + " " + e.getLastname());
			}

	}
	
	private List<Employee> readMarketingEmployees()
	{
		// Read all employees which belong to Marketing department 		
		String hql = "FROM Employee where department.departmentName like :dept_name";
		Session session = factory.openSession();
		
		Query query = session.createQuery(hql);
		query.setParameter("dept_name", "Marketing");
		
		List listResult = query.list(); 
		
		return listResult;
	}

}
