import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathBestPractices {

    public static void main(String... args) {

        ////////////////////////////////////////
        // First do the setup
        //
        // Instantiate the factory that supplies the DOM parser
        DocumentBuilderFactory builderFactory =
                DocumentBuilderFactory.newInstance();

        DocumentBuilder domParser = null;
        try {
            // Instantiate the DOM parser
            domParser = builderFactory.newDocumentBuilder();

            // Item 1: Load the DOM Document from the XML data using the parser
            Document domDocument =
                    domParser.parse(new FileInputStream("inventory.xml"));

            // Item 2: Instantiate an XPath object which compiles
            // and evaluates XPath expressions.
            XPath xPath = XPathFactory.newInstance().newXPath();

            String expr = null; // Used to hold the XPath expressions

            ////////////////////////////////////////
            // Now it's time to use the domDocument and the xPath objects,
            // repeatedly, to query the data out.

            // Use the XPath count() function to count the number of computers
            expr = "count(//computer)";
            Number computerCount = (Number) xPath.compile(expr).evaluate(domDocument, XPathConstants.NUMBER);
            System.out.println("1. There are " + computerCount + " computers in the inventory.");
            outputSeparator();


            // Get a list of the vendors
            // The following expression gets a set of nodes that have a name attribute,
            // then sets the value of each node using the name attribute.
            expr = "//vendor[@name]/@name";
            NodeList resultNodeList = (NodeList) xPath.compile(expr).evaluate(domDocument, XPathConstants.NODESET);
            if (resultNodeList != null) {
                int vendorCount = resultNodeList.getLength();
                System.out.println("2. There are " + vendorCount + " vendors:");
                for (int i = 0; i < vendorCount; i++) {
                    Node vendorNode = resultNodeList.item(i);
                    String name = vendorNode.getNodeValue();
                    System.out.println(name);
                }
            }
            outputSeparator();

            // Walk the DOM to print the computers in inventory
            Element rootElement = domDocument.getDocumentElement();
            NodeList modelNodeList = rootElement.getElementsByTagName("computer");

            System.out.println("3. Computer models in inventory:");

            if (modelNodeList != null && modelNodeList.getLength() > 0) {
                for (int i = 0; i < modelNodeList.getLength(); i++) {
                    Node node = modelNodeList.item(i);
                    if (node.getNodeType() == Node.ELEMENT_NODE) {
                        Element e = (Element) node;

                        displayNode(e, "model", "Model           : ");
                        displayNode(e, "os", "Operating System: ");
                        displayNode(e, "ram", "Installed RAM   : ");
                        displayNode(e, "cpu", "Processor       : ");
                        displayNode(e, "price", "Price           : $");
                        System.out.println();
                    }
                }
            }

        } catch (SAXException e) {
            // Even though we are using a DOM parser a SAXException is thrown
            // if the DocumentBuilder cannot parse the XML file
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        } catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    // Helper method to pretty up the output
    public static void outputSeparator() {
        System.out.println("=+=+=+=+=+=+=+=+");
    }

    // Helper method to output a node
    public static void displayNode(Element parent, String childName, String label) {
        NodeList nodeList = parent.getElementsByTagName(childName);
        System.out.println(label
                + nodeList.item(0).getChildNodes().item(0).getNodeValue());
    }




}