package com.javacodegeeks.nio.async_channels_tutorial.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.Channel;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public interface AsyncNIOMessageRelayParticipant {

    default void closeChannel(final Channel channel) {
	if (Objects.isNull(channel)) {
	    throw new IllegalArgumentException("Required channel");
	}

	try {
	    channel.close();
	} catch (IOException e) {
	    throw new RuntimeException("Unable to close channel", e);
	}
    }

    default ByteBuffer create(int capacity) {
	return ByteBuffer.allocate(capacity);
    }

    default String extract(final ByteBuffer buffer) {
	if (Objects.isNull(buffer)) {
	    throw new IllegalArgumentException("Buffer required");
	}

	buffer.flip();
	return new String(buffer.array()).trim();
    }

    default void updateMessageCache(String key, String value, ConcurrentMap<String, StringBuilder> messageCache) {
	if (messageCache.containsKey(key)) {
	    messageCache.get(key).append(value);
	} else {
	    messageCache.put(key, new StringBuilder(value));
	}
    }

    default void stopChannelGroup(AsynchronousChannelGroup group) {
	if (Objects.isNull(group)) {
	    throw new IllegalArgumentException("Required group");
	}

	try {
	    group.shutdownNow();
	} catch (IOException e) {
	    throw new RuntimeException("Unable to shutdown channel group");
	}
    }

    void start();

    void stop();
}
