package com.javacodegeeks.nio.async_channels_tutorial.file;

import static org.junit.Assert.assertTrue;

import java.io.File;

import org.junit.Before;
import org.junit.Test;

import com.javacodegeeks.nio.async_channels_tutorial.AbstractTest;

public class FileChannelTest extends AbstractTest {

    private static final String CONTENTS = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. "
            + "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate "
            + "velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";

    private String filePath = "/tmp/async-file.txt";

    @Before
    public void setUp() {
	final File file = new File(this.filePath);
	if (file.exists() && !file.isDirectory()) {
	    file.delete();
	}
    }

    @Test
    public void testWriteAndRead() {
	final FileChannel fileExample = new FileChannel();
	fileExample.write(this.filePath, CONTENTS);

	final String result = fileExample.read(this.filePath);
	System.out.println(result);

	assertTrue("Contents does not match", CONTENTS.equals(result));
    }
}
