package com.javacodegeeks.nio.async_channels_tutorial.server;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Map;
import java.util.Objects;

import org.junit.Test;

import com.javacodegeeks.nio.async_channels_tutorial.AbstractTest;

public class ClientServerTest extends AbstractTest {

    @Test
    public void testMultipleClients() {
	runTest(20, 5, 5, "Hello");
    }

    @Test
    public void testSingleClient() {
	runTest(1, 1, 1, "Hello");
    }

    @Test
    public void testSingleServerThreadManyClients() {
	runTest(20, 1, 5, "Hello");
    }

    private void runTest(final int numberOfConnections, final int serverThreadPoolSize, final int clientThreadPoolSize, final String echo) {
	Server server = null;
	Client client = null;
	try {
	    server = new Server(9999, serverThreadPoolSize, echo);
	    client = new Client(numberOfConnections, 9999, clientThreadPoolSize);

	    server.start();
	    client.start();

	    final Map<String, StringBuilder> messageCache = client.getMessageCache();

	    assertEquals("Invalid number of requests", numberOfConnections, messageCache.size());

	    int count = 1;
	    for (Map.Entry<String, StringBuilder> entry : client.getMessageCache().entrySet()) {
		System.out.println(String.format("%d : Request %s : Response : %s", Integer.valueOf(count), entry.getKey(), entry.getValue()));
		++count;

		assertTrue(String.format("Did not contain the echo %s", echo), entry.getValue().toString().trim().contains(echo));
		assertTrue("Server did not echo the request id back", entry.getValue().toString().trim().contains(entry.getKey()));
	    }
	} finally {

	    if (!Objects.isNull(client)) {
		client.stop();
	    }

	    if (!Objects.isNull(server)) {
		server.stop();
	    }
	}
    }
}
