/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource.barcode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import org.primefaces.application.resource.barcode.BarcodeGenerator;
import org.primefaces.application.resource.barcode.CodabarGenerator;
import org.primefaces.application.resource.barcode.Code128Generator;
import org.primefaces.application.resource.barcode.Code39Generator;
import org.primefaces.application.resource.barcode.DataMatrixGenerator;
import org.primefaces.application.resource.barcode.EAN13Generator;
import org.primefaces.application.resource.barcode.EAN8Generator;
import org.primefaces.application.resource.barcode.Int2of5Generator;
import org.primefaces.application.resource.barcode.PDF417Generator;
import org.primefaces.application.resource.barcode.PostnetGenerator;
import org.primefaces.application.resource.barcode.UPCAGenerator;
import org.primefaces.application.resource.barcode.UPCEGenerator;
import org.primefaces.util.AgentUtils;
import org.w3c.dom.DocumentFragment;

public class BarcodeHandler
extends BaseDynamicContentHandler {
    private static final Logger logger = Logger.getLogger(BarcodeHandler.class.getName());
    private final Map<String, BarcodeGenerator> generators = new HashMap<String, BarcodeGenerator>();

    public BarcodeHandler() {
        this.generators.put("int2of5", new Int2of5Generator());
        this.generators.put("codabar", new CodabarGenerator());
        this.generators.put("code39", new Code39Generator());
        this.generators.put("code128", new Code128Generator());
        this.generators.put("ean8", new EAN8Generator());
        this.generators.put("ean13", new EAN13Generator());
        this.generators.put("upca", new UPCAGenerator());
        this.generators.put("upce", new UPCEGenerator());
        this.generators.put("postnet", new PostnetGenerator());
        this.generators.put("pdf417", new PDF417Generator());
        this.generators.put("datamatrix", new DataMatrixGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ExternalContext externalContext = context.getExternalContext();
        String sessionKey = (String)params.get("pfdrid");
        Map session = externalContext.getSessionMap();
        Map barcodeMapping = (Map)session.get("primefaces.barcodeMapping");
        String value = (String)barcodeMapping.get(sessionKey);
        if (value != null) {
            try {
                BarcodeGenerator generator = this.generators.get(params.get("gen"));
                String format = (String)params.get("fmt");
                int orientation = Integer.parseInt((String)params.get("ori"));
                boolean cache = Boolean.valueOf((String)params.get("pfdrid_c"));
                if (AgentUtils.isLessThanIE(context, 9)) {
                    format = "png";
                }
                OutputStream out = externalContext.getResponseOutputStream();
                this.handleCache(externalContext, cache);
                if (format.equals("png")) {
                    externalContext.setResponseContentType("image/png");
                    BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider(out, "image/x-png", 150, 12, false, orientation);
                    generator.generate((CanvasProvider)bitmapCanvasProvider, value);
                    bitmapCanvasProvider.finish();
                } else if (format.equals("svg")) {
                    externalContext.setResponseContentType("image/svg+xml");
                    SVGCanvasProvider svgCanvasProvider = new SVGCanvasProvider(false, orientation);
                    generator.generate((CanvasProvider)svgCanvasProvider, value);
                    DocumentFragment frag = svgCanvasProvider.getDOMFragment();
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer trans = factory.newTransformer();
                    DOMSource src = new DOMSource(frag);
                    StreamResult res = new StreamResult(out);
                    trans.transform(src, res);
                }
                externalContext.setResponseStatus(200);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in streaming barcode resource. {0}", new Object[]{e.getMessage()});
            }
            finally {
                externalContext.responseFlushBuffer();
                context.responseComplete();
            }
        }
    }
}

