/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.calendar.CalendarUtils;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class CalendarRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Calendar calendar = (Calendar)component;
        if (calendar.isDisabled() || calendar.isReadonly()) {
            return;
        }
        String param = calendar.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            calendar.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)calendar);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Calendar calendar = (Calendar)component;
        String markupValue = CalendarUtils.getValueAsString(context, calendar);
        String widgetValue = calendar.isTimeOnly() ? CalendarUtils.getTimeOnlyValueAsString(context, calendar) : markupValue;
        this.encodeMarkup(context, calendar, markupValue);
        this.encodeScript(context, calendar, widgetValue);
    }

    protected void encodeMarkup(FacesContext context, Calendar calendar, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        String styleClass = calendar.getStyleClass();
        styleClass = styleClass == null ? "ui-calendar" : "ui-calendar " + styleClass;
        String inputId = clientId + "_input";
        boolean popup = calendar.isPopup();
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (calendar.getStyle() != null) {
            writer.writeAttribute("style", (Object)calendar.getStyle(), null);
        }
        if (!popup) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        this.encodeInput(context, calendar, inputId, value, popup);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, Calendar calendar, String id, String value, boolean popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String type = popup ? "text" : "hidden";
        String labelledBy = calendar.getLabelledBy();
        String inputStyle = calendar.getInputStyle();
        String inputStyleClass = calendar.getInputStyleClass();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)type, null);
        if (calendar.isRequired()) {
            writer.writeAttribute("aria-required", (Object)"true", null);
        }
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (popup) {
            String string = inputStyleClass = inputStyleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + inputStyleClass;
            if (calendar.isDisabled()) {
                inputStyleClass = inputStyleClass + " ui-state-disabled";
            }
            if (!calendar.isValid()) {
                inputStyleClass = inputStyleClass + " ui-state-error";
            }
            writer.writeAttribute("class", (Object)inputStyleClass, null);
            if (inputStyle != null) {
                writer.writeAttribute("style", (Object)inputStyle, null);
            }
            if (calendar.isReadonly() || calendar.isReadonlyInput()) {
                writer.writeAttribute("readonly", (Object)"readonly", null);
            }
            if (calendar.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            this.renderPassThruAttributes(context, (UIComponent)calendar, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
            this.renderDomEvents(context, (UIComponent)calendar, HTML.INPUT_TEXT_EVENTS);
        }
        if (labelledBy != null) {
            writer.writeAttribute("aria-labelledby", (Object)labelledBy, null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)calendar);
        }
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, Calendar calendar, String value) throws IOException {
        String showOn;
        String beforeShow;
        String beforeShowDay;
        String clientId = calendar.getClientId(context);
        Locale locale = calendar.calculateLocale(context);
        String pattern = calendar.isTimeOnly() ? calendar.calculateTimeOnlyPattern() : calendar.calculatePattern();
        String mask = calendar.getMask();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Calendar", calendar.resolveWidgetVar(), clientId);
        wb.attr("popup", calendar.isPopup()).attr("locale", locale.toString()).attr("dateFormat", CalendarUtils.convertPattern(pattern));
        Object pagedate = calendar.getPagedate();
        String defaultDate = null;
        if (calendar.isConversionFailed()) {
            defaultDate = CalendarUtils.getValueAsString(context, calendar, new Date());
        } else if (!this.isValueBlank(value)) {
            defaultDate = value;
        } else if (pagedate != null) {
            defaultDate = CalendarUtils.getValueAsString(context, calendar, pagedate);
        }
        wb.attr("defaultDate", defaultDate, null).attr("numberOfMonths", calendar.getPages(), 1).attr("minDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMindate()), null).attr("maxDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMaxdate()), null).attr("showButtonPanel", calendar.isShowButtonPanel(), false).attr("showTodayButton", calendar.isShowTodayButton(), true).attr("showWeek", calendar.isShowWeek(), false).attr("disabledWeekends", calendar.isDisabledWeekends(), false).attr("disabled", calendar.isDisabled(), false).attr("yearRange", calendar.getYearRange(), null);
        if (calendar.isNavigator()) {
            wb.attr("changeMonth", true).attr("changeYear", true);
        }
        if (calendar.getEffect() != null) {
            wb.attr("showAnim", calendar.getEffect()).attr("duration", calendar.getEffectDuration());
        }
        if ((beforeShowDay = calendar.getBeforeShowDay()) != null) {
            wb.nativeAttr("preShowDay", beforeShowDay);
        }
        if ((beforeShow = calendar.getBeforeShow()) != null) {
            wb.nativeAttr("preShow", beforeShow);
        }
        if (!(showOn = calendar.getShowOn()).equalsIgnoreCase("focus")) {
            wb.attr("showOn", showOn).attr("buttonTabindex", calendar.getButtonTabindex());
        }
        if (calendar.isShowOtherMonths()) {
            wb.attr("showOtherMonths", true).attr("selectOtherMonths", calendar.isSelectOtherMonths());
        }
        if (calendar.hasTime()) {
            String timeControlType = calendar.getTimeControlType();
            wb.attr("timeOnly", calendar.isTimeOnly()).attr("stepHour", calendar.getStepHour()).attr("stepMinute", calendar.getStepMinute()).attr("stepSecond", calendar.getStepSecond()).attr("hourMin", calendar.getMinHour()).attr("hourMax", calendar.getMaxHour()).attr("minuteMin", calendar.getMinMinute()).attr("minuteMax", calendar.getMaxMinute()).attr("secondMin", calendar.getMinSecond()).attr("secondMax", calendar.getMaxSecond()).attr("timeInput", calendar.isTimeInput()).attr("controlType", timeControlType, null).attr("showHour", calendar.getShowHour(), null).attr("showMinute", calendar.getShowMinute(), null).attr("showSecond", calendar.getShowSecond(), null).attr("showMillisec", calendar.getShowMillisec(), null);
            String timeControlObject = calendar.getTimeControlObject();
            if (timeControlObject != null && timeControlType.equalsIgnoreCase("custom")) {
                wb.nativeAttr("timeControlObject", timeControlObject);
            }
        }
        if (mask != null && !mask.equals("false")) {
            String patternTemplate = calendar.getPattern() == null ? pattern : calendar.getPattern();
            String maskTemplate = mask.equals("true") ? patternTemplate.replaceAll("[a-zA-Z]", "9") : mask;
            wb.attr("mask", maskTemplate).attr("maskSlotChar", calendar.getMaskSlotChar(), null).attr("maskAutoClear", calendar.isMaskAutoClear(), true);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)calendar);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        Calendar calendar = (Calendar)component;
        String submittedValue = (String)value;
        SimpleDateFormat format = null;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        try {
            Converter converter = calendar.getConverter();
            if (converter != null) {
                return converter.getAsObject(context, (UIComponent)calendar, submittedValue);
            }
        }
        catch (ConverterException e) {
            calendar.setConversionFailed(true);
            throw e;
        }
        try {
            Converter converter;
            Class type;
            ValueExpression ve = calendar.getValueExpression("value");
            if (ve != null && (type = ve.getType(context.getELContext())) != null && type != Object.class && type != Date.class && (converter = context.getApplication().createConverter(type)) != null) {
                return converter.getAsObject(context, (UIComponent)calendar, submittedValue);
            }
        }
        catch (ConverterException e) {
            calendar.setConversionFailed(true);
            throw e;
        }
        format = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
        format.setLenient(false);
        format.setTimeZone(calendar.calculateTimeZone());
        try {
            return format.parse(submittedValue);
        }
        catch (ParseException e) {
            calendar.setConversionFailed(true);
            FacesMessage message = null;
            Object[] params = new Object[]{submittedValue, format.format(new Date()), MessageFactory.getLabel(context, (UIComponent)calendar)};
            message = calendar.isTimeOnly() ? MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.TIME", FacesMessage.SEVERITY_ERROR, params) : (calendar.hasTime() ? MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.DATETIME", FacesMessage.SEVERITY_ERROR, params) : MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.DATE", FacesMessage.SEVERITY_ERROR, params));
            throw new ConverterException(message);
        }
    }
}

