/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="captcha/captcha.js")})
public class Captcha
extends UIInput
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Captcha";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.CaptchaRenderer";
    public static final String PUBLIC_KEY = "primefaces.PUBLIC_CAPTCHA_KEY";
    public static final String PRIVATE_KEY = "primefaces.PRIVATE_CAPTCHA_KEY";
    public static final String INVALID_MESSAGE_ID = "primefaces.captcha.INVALID";

    public Captcha() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), (Object)"light");
    }

    public void setTheme(String _theme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.theme), (Object)_theme);
    }

    public String getLanguage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.language), (Object)"en");
    }

    public void setLanguage(String _language) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.language), (Object)_language);
    }

    public int getTabindex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), (Object)0);
    }

    public void setTabindex(int _tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)_tabindex);
    }

    public String getLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.label), null);
    }

    public void setLabel(String _label) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.label), (Object)_label);
    }

    public String getCallback() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.callback), null);
    }

    public void setCallback(String _callback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.callback), (Object)_callback);
    }

    public String getExpired() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expired), null);
    }

    public void setExpired(String _expired) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expired), (Object)_expired);
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid()) {
            boolean result = false;
            try {
                String inputLine;
                URL url = new URL("https://www.google.com/recaptcha/api/siteverify");
                URLConnection conn = url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String postBody = this.createPostParameters(context, value);
                OutputStream out = conn.getOutputStream();
                out.write(postBody.getBytes());
                out.flush();
                out.close();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = rd.readLine()) != null) {
                    response.append(inputLine);
                }
                JSONObject json = new JSONObject(response.toString());
                result = json.getBoolean("success");
                rd.close();
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                RequestContext requestContext = RequestContext.getCurrentInstance();
                if (requestContext.isAjaxRequest()) {
                    requestContext.execute("grecaptcha.reset()");
                }
            }
            if (!result) {
                this.setValid(false);
                String validatorMessage = this.getValidatorMessage();
                FacesMessage msg = null;
                if (validatorMessage != null) {
                    msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
                } else {
                    Object[] params = new Object[]{MessageFactory.getLabel(context, (UIComponent)this), (String)value};
                    msg = MessageFactory.getMessage(INVALID_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params);
                }
                context.addMessage(this.getClientId(context), msg);
            }
        }
    }

    private String createPostParameters(FacesContext context, Object value) throws UnsupportedEncodingException {
        String privateKey = (String)context.getApplication().evaluateExpressionGet(context, context.getExternalContext().getInitParameter(PRIVATE_KEY), String.class);
        if (privateKey == null) {
            throw new FacesException("Cannot find private key for catpcha, use primefaces.PRIVATE_CAPTCHA_KEY context-param to define one");
        }
        StringBuilder postParams = new StringBuilder();
        postParams.append("secret=").append(URLEncoder.encode(privateKey, "UTF-8"));
        postParams.append("&response=").append(URLEncoder.encode((String)value, "UTF-8"));
        String params = postParams.toString();
        postParams.setLength(0);
        return params;
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        theme,
        language,
        tabindex,
        label,
        callback,
        expired;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

