/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.WidgetBuilder;

public class DataGridRenderer
extends DataRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        if (grid.isPaginationRequest(context)) {
            grid.updatePaginationData(context, grid);
            if (grid.isLazy()) {
                grid.loadLazyData();
            }
            this.encodeContent(context, grid);
        } else {
            this.encodeMarkup(context, grid);
            this.encodeScript(context, grid);
        }
    }

    protected void encodeScript(FacesContext context, DataGrid grid) throws IOException {
        String clientId = grid.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataGrid", grid.resolveWidgetVar(), clientId);
        if (grid.isPaginator()) {
            this.encodePaginatorConfig(context, grid, wb);
        }
        this.encodeClientBehaviors(context, grid);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataGrid grid) throws IOException {
        String contentClass;
        String styleClass;
        if (grid.isLazy()) {
            grid.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId(context);
        boolean hasPaginator = grid.isPaginator();
        boolean empty = grid.getRowCount() == 0;
        String layout = grid.getLayout();
        String paginatorPosition = grid.getPaginatorPosition();
        String style = grid.getStyle();
        String string = styleClass = grid.getStyleClass() == null ? "ui-datagrid ui-widget" : "ui-datagrid ui-widget " + grid.getStyleClass();
        String string2 = empty ? "ui-datagrid-content ui-datagrid-content-empty ui-widget-content" : (contentClass = layout.equals("tabular") ? "ui-datagrid-content ui-widget-content" : "ui-datagrid-content ui-widget-content ui-grid ui-grid-responsive");
        if (hasPaginator) {
            grid.calculateFirst();
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, grid, "header", "ui-datagrid-header ui-widget-header ui-corner-top");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, grid, "top");
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (empty) {
            UIComponent emptyFacet = grid.getFacet("emptyMessage");
            if (emptyFacet != null) {
                emptyFacet.encodeAll(context);
            } else {
                writer.write(grid.getEmptyMessage());
            }
        } else {
            this.encodeContent(context, grid);
        }
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, grid, "bottom");
        }
        this.encodeFacet(context, grid, "footer", "ui-datagrid-footer ui-widget-header ui-corner-bottom");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, DataGrid grid) throws IOException {
        String layout = grid.getLayout();
        if (layout.equals("tabular")) {
            this.encodeTable(context, grid);
        } else if (layout.equals("grid")) {
            this.encodeGrid(context, grid);
        } else {
            throw new FacesException(layout + " is not a valid value for DataGrid layout. Possible values are 'tabular' and 'grid'.");
        }
    }

    protected void encodeGrid(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        String columnClass = "ui-datagrid-column " + GridLayoutUtils.getColumnClass(columns);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            grid.setRowIndex(rowIndex);
            if (!grid.isRowAvailable()) break;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-grid-row", null);
            for (int j = 0; j < columns; ++j) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)columnClass, null);
                grid.setRowIndex(rowIndex);
                if (grid.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)grid);
                }
                ++rowIndex;
                writer.endElement("div");
            }
            writer.endElement("div");
        }
        grid.setRowIndex(-1);
    }

    protected void encodeTable(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("class", (Object)"ui-datagrid-data", null);
        writer.startElement("tbody", null);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            grid.setRowIndex(rowIndex);
            if (!grid.isRowAvailable()) break;
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-datagrid-row", null);
            for (int j = 0; j < columns; ++j) {
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-datagrid-column", null);
                grid.setRowIndex(rowIndex);
                if (grid.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)grid);
                }
                ++rowIndex;
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        grid.setRowIndex(-1);
        writer.endElement("tbody");
        writer.endElement("table");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

