/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.model.DataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.MultiSortState;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.AddRowFeature;
import org.primefaces.component.datatable.feature.CellEditFeature;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.DraggableRowsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.context.RequestContext;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.ReorderEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.event.ToggleSelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.mobile.event.SwipeEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SelectableDataModelWrapper;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataTable
extends UIData
implements Widget,
RTLAware,
ClientBehaviorHolder,
PrimeClientBehaviorHolder,
Pageable {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String SB_GET_SELECTED_ROW_KEYS_AS_STRING = DataTable.class.getName() + "#getSelectedRowKeysAsString";
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String TABLE_WRAPPER_CLASS = "ui-datatable-tablewrapper";
    public static final String REFLOW_CLASS = "ui-datatable-reflow";
    public static final String RTL_CLASS = "ui-datatable-rtl";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String DYNAMIC_COLUMN_HEADER_CLASS = "ui-dynamic-column";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTABLE_ROW_CLASS = "ui-datatable-selectable";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-datatable-empty-message";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bottom";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String UNSELECTABLE_COLUMN_CLASS = "ui-column-unselectable";
    public static final String HIDDEN_COLUMN_CLASS = "ui-helper-hidden";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_TITLE_CLASS = "ui-column-title";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter ui-widget ui-state-default ui-corner-left";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor ui-helper-clearfix";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String VIRTUALSCROLL_WRAPPER_CLASS = "ui-datatable-virtualscroll-wrapper";
    public static final String VIRTUALSCROLL_TABLE_CLASS = "ui-datatable-virtualscroll-table";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    public static final String HEADER_ROW_CLASS = "ui-rowgroup-header ui-datatable-headerrow ui-widget-header";
    public static final String ROW_GROUP_TOGGLER_CLASS = "ui-rowgroup-toggler";
    public static final String ROW_GROUP_TOGGLER_ICON_CLASS = "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-s";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String STICKY_HEADER_CLASS = "ui-datatable-sticky";
    public static final String ARIA_FILTER_BY = "primefaces.datatable.aria.FILTER_BY";
    public static final String ARIA_HEADER_CHECKBOX_ALL = "primefaces.datatable.aria.HEADER_CHECKBOX_ALL";
    public static final String SORT_LABEL = "primefaces.datatable.SORT_LABEL";
    public static final String SORT_ASC = "primefaces.datatable.SORT_ASC";
    public static final String SORT_DESC = "primefaces.datatable.SORT_DESC";
    public static final String ROW_GROUP_TOGGLER = "primefaces.rowgrouptoggler.aria.ROW_GROUP_TOGGLER";
    public static final String MOBILE_CONTAINER_CLASS = "ui-datatable ui-shadow";
    public static final String MOBILE_TABLE_CLASS = "ui-responsive ui-table table-stripe";
    public static final String MOBILE_COLUMN_HEADER_CLASS = "ui-column-header";
    public static final String MOBILE_ROW_CLASS = "ui-table-row";
    public static final String MOBILE_SORT_ICON_CLASS = "ui-sortable-column-icon ui-icon-bars ui-btn-icon-notext ui-btn-right";
    public static final String MOBILE_SORT_ICON_ASC_CLASS = "ui-sortable-column-icon ui-icon-arrow-u ui-btn-icon-notext ui-btn-right";
    public static final String MOBILE_SORT_ICON_DESC_CLASS = "ui-sortable-column-icon ui-icon-arrow-d ui-btn-icon-notext ui-btn-right";
    public static final String MOBILE_SORTED_COLUMN_CLASS = "ui-column-sorted";
    public static final String MOBILE_CELL_LABEL = "ui-table-cell-label";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put("page", PageEvent.class);
            this.put("sort", SortEvent.class);
            this.put("filter", FilterEvent.class);
            this.put("rowSelect", SelectEvent.class);
            this.put("rowUnselect", UnselectEvent.class);
            this.put("rowEdit", RowEditEvent.class);
            this.put("rowEditInit", RowEditEvent.class);
            this.put("rowEditCancel", RowEditEvent.class);
            this.put("colResize", ColumnResizeEvent.class);
            this.put("toggleSelect", ToggleSelectEvent.class);
            this.put("colReorder", null);
            this.put("contextMenu", SelectEvent.class);
            this.put("rowSelectRadio", SelectEvent.class);
            this.put("rowSelectCheckbox", SelectEvent.class);
            this.put("rowUnselectCheckbox", UnselectEvent.class);
            this.put("rowDblselect", SelectEvent.class);
            this.put("rowToggle", ToggleEvent.class);
            this.put("cellEditInit", CellEditEvent.class);
            this.put("cellEdit", CellEditEvent.class);
            this.put("rowReorder", ReorderEvent.class);
            this.put("swipeleft", SwipeEvent.class);
            this.put("swiperight", SwipeEvent.class);
            this.put("tap", SelectEvent.class);
            this.put("taphold", SelectEvent.class);
            this.put("cellEditCancel", CellEditEvent.class);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    static Map<DataTableFeatureKey, DataTableFeature> FEATURES = new HashMap<DataTableFeatureKey, DataTableFeature>();
    private List filterMetadata;
    private boolean reset = false;
    private List<Object> selectedRowKeys = new ArrayList<Object>();
    private int columnsCount = -1;
    int columnsCountWithSpan = -1;
    private List<UIColumn> columns;
    private UIColumn sortColumn;
    private List<SortMeta> multiSortMeta = null;
    private Columns dynamicColumns;
    private ValueExpression sortByVE;
    private List<UIComponent> iterableChildren;

    public DataTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
    }

    public String getScrollHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), null);
    }

    public void setScrollHeight(String _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
    }

    public String getScrollWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), null);
    }

    public void setScrollWidth(String _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isLiveScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScroll), (Object)false);
    }

    public void setLiveScroll(boolean _liveScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScroll), (Object)_liveScroll);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
    }

    public String getOnExpandStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onExpandStart), null);
    }

    public void setOnExpandStart(String _onExpandStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onExpandStart), (Object)_onExpandStart);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
    }

    public int getScrollRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollRows), (Object)0);
    }

    public void setScrollRows(int _scrollRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollRows), (Object)_scrollRows);
    }

    public Object getRowKey() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowKey), null);
    }

    public void setRowKey(Object _rowKey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowKey), _rowKey);
    }

    public String getFilterEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterEvent), null);
    }

    public void setFilterEvent(String _filterEvent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterEvent), (Object)_filterEvent);
    }

    public int getFilterDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterDelay), (Object)Integer.MAX_VALUE);
    }

    public void setFilterDelay(int _filterDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterDelay), (Object)_filterDelay);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
    }

    public boolean isDraggableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableColumns), (Object)false);
    }

    public void setDraggableColumns(boolean _draggableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableColumns), (Object)_draggableColumns);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
    }

    public List getFilteredValue() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filteredValue), null);
    }

    public void setFilteredValue(List _filteredValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filteredValue), (Object)_filteredValue);
    }

    public String getSortMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortMode), (Object)"single");
    }

    public void setSortMode(String _sortMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortMode), (Object)_sortMode);
    }

    public String getEditMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editMode), (Object)"row");
    }

    public void setEditMode(String _editMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editMode), (Object)_editMode);
    }

    public boolean isEditingRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editingRow), (Object)false);
    }

    public void setEditingRow(boolean _editingRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editingRow), (Object)_editingRow);
    }

    public String getCellSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cellSeparator), null);
    }

    public void setCellSeparator(String _cellSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cellSeparator), (Object)_cellSeparator);
    }

    public String getSummary() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.summary), null);
    }

    public void setSummary(String _summary) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.summary), (Object)_summary);
    }

    public int getFrozenRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.frozenRows), (Object)0);
    }

    public void setFrozenRows(int _frozenRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.frozenRows), (Object)_frozenRows);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
    }

    public boolean isLiveResize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveResize), (Object)false);
    }

    public void setLiveResize(boolean _liveResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveResize), (Object)_liveResize);
    }

    public boolean isStickyHeader() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stickyHeader), (Object)false);
    }

    public void setStickyHeader(boolean _stickyHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stickyHeader), (Object)_stickyHeader);
    }

    public boolean isExpandedRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandedRow), (Object)false);
    }

    public void setExpandedRow(boolean _expandedRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandedRow), (Object)_expandedRow);
    }

    public boolean isDisabledSelection() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledSelection), (Object)false);
    }

    public void setDisabledSelection(boolean _disabledSelection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledSelection), (Object)_disabledSelection);
    }

    public String getRowSelectMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowSelectMode), (Object)"new");
    }

    public void setRowSelectMode(String _rowSelectMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowSelectMode), (Object)_rowSelectMode);
    }

    public String getRowExpandMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowExpandMode), (Object)"multiple");
    }

    public void setRowExpandMode(String _rowExpandMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowExpandMode), (Object)_rowExpandMode);
    }

    public Object getDataLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dataLocale), null);
    }

    public void setDataLocale(Object _dataLocale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dataLocale), _dataLocale);
    }

    public boolean isNativeElements() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nativeElements), (Object)false);
    }

    public void setNativeElements(boolean _nativeElements) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nativeElements), (Object)_nativeElements);
    }

    public int getFrozenColumns() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.frozenColumns), (Object)0);
    }

    public void setFrozenColumns(int _frozenColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.frozenColumns), (Object)_frozenColumns);
    }

    public boolean isDraggableRows() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableRows), (Object)false);
    }

    public void setDraggableRows(boolean _draggableRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableRows), (Object)_draggableRows);
    }

    public boolean isCaseSensitiveSort() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)false);
    }

    public void setCaseSensitiveSort(boolean _caseSensitiveSort) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)_caseSensitiveSort);
    }

    public boolean isSkipChildren() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.skipChildren), (Object)false);
    }

    public void setSkipChildren(boolean _skipChildren) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.skipChildren), (Object)_skipChildren);
    }

    public boolean isDisabledTextSelection() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledTextSelection), (Object)true);
    }

    public void setDisabledTextSelection(boolean _disabledTextSelection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledTextSelection), (Object)_disabledTextSelection);
    }

    public String getSortField() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortField), null);
    }

    public void setSortField(String _sortField) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortField), (Object)_sortField);
    }

    public String getInitMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initMode), (Object)"load");
    }

    public void setInitMode(String _initMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.initMode), (Object)_initMode);
    }

    public int getNullSortOrder() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nullSortOrder), (Object)1);
    }

    public void setNullSortOrder(int _nullSortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nullSortOrder), (Object)_nullSortOrder);
    }

    public String getTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), (Object)"0");
    }

    public void setTabindex(String _tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)_tabindex);
    }

    public boolean isReflow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.reflow), (Object)false);
    }

    public void setReflow(boolean _reflow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.reflow), (Object)_reflow);
    }

    public int getLiveScrollBuffer() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScrollBuffer), (Object)0);
    }

    public void setLiveScrollBuffer(int _liveScrollBuffer) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScrollBuffer), (Object)_liveScrollBuffer);
    }

    public boolean isRowHover() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowHover), (Object)false);
    }

    public void setRowHover(boolean _rowHover) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowHover), (Object)_rowHover);
    }

    public String getResizeMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizeMode), (Object)"fit");
    }

    public void setResizeMode(String _resizeMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizeMode), (Object)_resizeMode);
    }

    public String getAriaRowLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ariaRowLabel), null);
    }

    public void setAriaRowLabel(String _ariaRowLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ariaRowLabel), (Object)_ariaRowLabel);
    }

    public boolean isSaveOnCellBlur() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.saveOnCellBlur), (Object)true);
    }

    public void setSaveOnCellBlur(boolean _saveOnCellBlur) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.saveOnCellBlur), (Object)_saveOnCellBlur);
    }

    public boolean isClientCache() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientCache), (Object)false);
    }

    public void setClientCache(boolean _clientCache) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientCache), (Object)_clientCache);
    }

    public boolean isMultiViewState() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.multiViewState), (Object)false);
    }

    public void setMultiViewState(boolean _multiViewState) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.multiViewState), (Object)_multiViewState);
    }

    public List getFilterBy() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterBy), null);
    }

    public void setFilterBy(List _filterBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterBy), (Object)_filterBy);
    }

    public String getGlobalFilter() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.globalFilter), null);
    }

    public void setGlobalFilter(String _globalFilter) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.globalFilter), (Object)_globalFilter);
    }

    public String getCellEditMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cellEditMode), (Object)"eager");
    }

    public void setCellEditMode(String _cellEditMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cellEditMode), (Object)_cellEditMode);
    }

    public boolean isExpandableRowGroups() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandableRowGroups), (Object)false);
    }

    public void setExpandableRowGroups(boolean _expandableRowGroups) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandableRowGroups), (Object)_expandableRowGroups);
    }

    public boolean isVirtualScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.virtualScroll), (Object)false);
    }

    public void setVirtualScroll(boolean _virtualScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.virtualScroll), (Object)_virtualScroll);
    }

    public DataTableFeature getFeature(DataTableFeatureKey key) {
        return FEATURES.get((Object)key);
    }

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isCellEditCancelRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditCancel");
    }

    public boolean isCellEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditInit");
    }

    public boolean isClientCacheRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_clientCache");
    }

    public boolean isPageStateRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pageState");
    }

    public boolean isRowEditCancelRequest(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(this.getClientId(context) + "_rowEditAction");
        return value != null && value.equals("cancel");
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (UIComponent child : this.getChildren()) {
            String selectionMode;
            if (!child.isRendered() || !(child instanceof Column) || (selectionMode = ((Column)child).getSelectionMode()) == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    @Override
    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (this.isFilterRequest(context)) {
            FEATURES.get((Object)DataTableFeatureKey.FILTER).decode(context, this);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        List filterMeta;
        super.processUpdates(context);
        ValueExpression selectionVE = this.getValueExpression(PropertyKeys.selection.toString());
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), this.getLocalSelection());
            this.setSelection(null);
        }
        if ((filterMeta = this.getFilterMetadata()) != null && !filterMeta.isEmpty()) {
            ELContext eLContext = context.getELContext();
            for (FilterMeta fm : filterMeta) {
                UIColumn column = fm.getColumn();
                ValueExpression columnFilterValueVE = column.getValueExpression(Column.PropertyKeys.filterValue.toString());
                if (columnFilterValueVE == null) continue;
                if (column.isDynamic()) {
                    DynamicColumn dynamicColumn = (DynamicColumn)column;
                    dynamicColumn.applyStatelessModel();
                    columnFilterValueVE.setValue(eLContext, fm.getFilterValue());
                    dynamicColumn.cleanStatelessModel();
                }
                columnFilterValueVE.setValue(eLContext, fm.getFilterValue());
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("rowSelect") || eventName.equals("rowSelectRadio") || eventName.equals("contextMenu") || eventName.equals("rowSelectCheckbox") || eventName.equals("rowDblselect")) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("rowUnselect") || eventName.equals("rowUnselectCheckbox")) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("page")) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
            } else if (eventName.equals("sort")) {
                UIColumn sortColumn;
                SortOrder order;
                int sortColumnIndex = 0;
                if (this.isMultiSort()) {
                    String[] sortDirs = ((String)params.get(clientId + "_sortDir")).split(",");
                    String[] sortKeys = ((String)params.get(clientId + "_sortKey")).split(",");
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam(sortDirs[sortDirs.length - 1]));
                    sortColumn = this.findColumn(sortKeys[sortKeys.length - 1]);
                    sortColumnIndex = sortKeys.length - 1;
                } else {
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam((String)params.get(clientId + "_sortDir")));
                    sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                }
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order, sortColumnIndex);
            } else if (eventName.equals("filter")) {
                wrapperEvent = new FilterEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getFilteredValue());
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                int rowIndex = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
                this.setRowIndex(rowIndex);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Double.valueOf((String)params.get(clientId + "_width")).intValue();
                int height = Double.valueOf((String)params.get(clientId + "_height")).intValue();
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("toggleSelect")) {
                boolean checked = Boolean.valueOf((String)params.get(clientId + "_checked"));
                wrapperEvent = new ToggleSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), checked);
            } else if (eventName.equals("colReorder")) {
                wrapperEvent = behaviorEvent;
            } else if (eventName.equals("rowToggle")) {
                boolean expansion = params.containsKey(clientId + "_rowExpansion");
                Visibility visibility = expansion ? Visibility.VISIBLE : Visibility.HIDDEN;
                String rowIndex = expansion ? (String)params.get(clientId + "_expandedRowIndex") : (String)params.get(clientId + "_collapsedRowIndex");
                this.setRowIndex(Integer.parseInt(rowIndex));
                wrapperEvent = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility, this.getRowData());
            } else if (eventName.equals("cellEdit") || eventName.equals("cellEditCancel") || eventName.equals("cellEditInit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                int rowIndex = Integer.parseInt(cellInfo[0]);
                int cellIndex = Integer.parseInt(cellInfo[1]);
                String rowKey = null;
                if (cellInfo.length == 3) {
                    rowKey = cellInfo[2];
                }
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), rowIndex, column, rowKey);
            } else if (eventName.equals("rowReorder")) {
                int fromIndex = Integer.parseInt((String)params.get(clientId + "_fromIndex"));
                int toIndex = Integer.parseInt((String)params.get(clientId + "_toIndex"));
                wrapperEvent = new ReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), fromIndex, toIndex);
            } else if (eventName.equals("swipeleft") || eventName.equals("swiperight")) {
                String rowkey = (String)params.get(clientId + "_rowkey");
                wrapperEvent = new SwipeEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowkey));
            } else if (eventName.equals("tap") || eventName.equals("taphold")) {
                String rowkey = (String)params.get(clientId + "_rowkey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowkey));
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        if (this.getFrozenColumns() > 0) {
            UIColumn column = this.findColumnInGroup(clientId, this.getColumnGroup("frozenHeader"));
            if (column == null) {
                column = this.findColumnInGroup(clientId, this.getColumnGroup("scrollableHeader"));
            }
            if (column != null) {
                return column;
            }
        } else {
            return this.findColumnInGroup(clientId, this.getColumnGroup("header"));
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public UIColumn findColumnInGroup(String clientId, ColumnGroup group) {
        if (group == null) {
            return null;
        }
        FacesContext context = this.getFacesContext();
        for (UIComponent row : group.getChildren()) {
            for (UIComponent rowChild : row.getChildren()) {
                if (rowChild instanceof Column) {
                    if (!rowChild.getClientId(context).equals(clientId)) continue;
                    return (UIColumn)rowChild;
                }
                if (!(rowChild instanceof Columns)) continue;
                Columns uiColumns = (Columns)rowChild;
                List<DynamicColumn> dynaColumns = uiColumns.getDynamicColumns();
                for (UIColumn uIColumn : dynaColumns) {
                    if (!uIColumn.getColumnKey().equals(clientId)) continue;
                    return uIColumn;
                }
            }
        }
        return null;
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            this.calculateFirst();
            FacesContext context = this.getFacesContext();
            int first = this.getFirst();
            if (this.isClientCacheRequest(context)) {
                Map params = context.getExternalContext().getRequestParameterMap();
                first = Integer.valueOf((String)params.get(this.getClientId(context) + "_first")) + this.getRows();
            }
            data = this.isMultiSort() ? lazyModel.load(first, this.getRows(), this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(first, this.getRows(), this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isRequestSource(context) && (this.isPaginator() || this.isLiveScroll()) && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void loadLazyScrollData(int offset, int rows) {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            data = this.isMultiSort() ? lazyModel.load(offset, rows, this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(offset, rows, this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(rows);
            lazyModel.setWrappedData(data);
            if (this.isRequestSource(this.getFacesContext()) && (this.isPaginator() || this.isLiveScroll()) && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected String resolveSortField() {
        String sortField = null;
        UIColumn column = this.getSortColumn();
        ValueExpression tableSortByVE = this.getValueExpression(PropertyKeys.sortBy.toString());
        Object tableSortByProperty = this.getSortBy();
        if (column == null) {
            String field = this.getSortField();
            sortField = field == null ? (tableSortByVE == null ? (String)tableSortByProperty : this.resolveStaticField(tableSortByVE)) : field;
        } else {
            ValueExpression columnSortByVE = column.getValueExpression(PropertyKeys.sortBy.toString());
            if (column.isDynamic()) {
                ((DynamicColumn)this.sortColumn).applyStatelessModel();
                Object sortByProperty = this.sortColumn.getSortBy();
                String field = column.getField();
                sortField = field == null ? (sortByProperty == null ? this.resolveDynamicField(columnSortByVE) : sortByProperty.toString()) : field;
            } else {
                String field = column.getField();
                sortField = field == null ? (columnSortByVE == null ? (String)column.getSortBy() : this.resolveStaticField(columnSortByVE)) : field;
            }
        }
        return sortField;
    }

    public SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(sortOrder.toUpperCase(Locale.ENGLISH));
    }

    public String resolveStaticField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            return expressionString.substring(expressionString.indexOf(".") + 1);
        }
        return null;
    }

    public String resolveDynamicField(ValueExpression expression) {
        if (expression == null) {
            return null;
        }
        FacesContext context = this.getFacesContext();
        ELContext elContext = context.getELContext();
        String expressionString = expression.getExpressionString();
        if (expressionString.startsWith("#{" + this.getVar() + "[")) {
            expressionString = expressionString.substring(expressionString.indexOf("[") + 1, expressionString.indexOf("]"));
            expressionString = "#{" + expressionString + "}";
            ValueExpression dynaVE = context.getApplication().getExpressionFactory().createValueExpression(elContext, expressionString, String.class);
            return (String)dynaVE.getValue(elContext);
        }
        return (String)expression.getValue(elContext);
    }

    public void clearLazyCache() {
        if (this.getDataModel() instanceof LazyDataModel) {
            LazyDataModel model = (LazyDataModel)this.getDataModel();
            model.setWrappedData(null);
        }
    }

    public Map<String, Object> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, Object> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public int getScrollOffset() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"scrollOffset"), (Object)0);
    }

    public void setScrollOffset(int scrollOffset) {
        this.getStateHelper().put((Serializable)((Object)"scrollOffset"), (Object)scrollOffset);
    }

    public List getFilterMetadata() {
        return this.filterMetadata;
    }

    public void setFilterMetadata(List filterMetadata) {
        this.filterMetadata = filterMetadata;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFilteredValue(null);
        this.setFilters(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
        this.reset = true;
        this.setValueExpression("sortBy", this.getDefaultSortByVE());
        this.setSortFunction(this.getDefaultSortFunction());
        this.setSortOrder(this.getDefaultSortOrder());
        this.setSortByVE(null);
        this.setSortColumn(null);
        this.setSortField(null);
        this.setDefaultSort(true);
        this.clearMultiSortMeta();
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public Object getLocalSelection() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isRequestSource(FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return partialSource != null && this.getClientId(context).equals(partialSource);
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof SubTable)) continue;
            return (SubTable)kid;
        }
        return null;
    }

    public Object getRowKeyFromModel(Object object) {
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled.");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowKey(object);
    }

    public Object getRowData(String rowKey) {
        boolean hasRowKeyVe = this.getValueExpression(PropertyKeys.rowKey.toString()) != null;
        DataModel model = this.getDataModel();
        if (hasRowKeyVe && !(model instanceof LazyDataModel)) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            String var = this.getVar();
            Collection data = (Collection)this.getDataModel().getWrappedData();
            if (data != null) {
                for (Object object : data) {
                    requestMap.put(var, object);
                    if (!String.valueOf(this.getRowKey()).equals(rowKey)) continue;
                    return object;
                }
            }
            return null;
        }
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled or you need to define rowKey attribute");
        }
        return ((SelectableDataModel)model).getRowData(rowKey);
    }

    public void findSelectedRowKeys() {
        Object selection = this.getSelection();
        this.selectedRowKeys = new ArrayList<Object>();
        boolean hasRowKeyVe = this.getValueExpression(PropertyKeys.rowKey.toString()) != null;
        String var = this.getVar();
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        if (this.isSelectionEnabled() && selection != null) {
            if (this.isSingleSelectionMode()) {
                this.addToSelectedRowKeys(selection, requestMap, var, hasRowKeyVe);
            } else if (selection.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(selection); ++i) {
                    this.addToSelectedRowKeys(Array.get(selection, i), requestMap, var, hasRowKeyVe);
                }
            } else {
                List list = (List)selection;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.addToSelectedRowKeys(it.next(), requestMap, var, hasRowKeyVe);
                }
            }
            requestMap.remove(var);
        }
    }

    protected void addToSelectedRowKeys(Object object, Map<String, Object> map, String var, boolean hasRowKey) {
        if (hasRowKey) {
            map.put(var, object);
            Object rowKey = this.getRowKey();
            if (rowKey != null) {
                this.selectedRowKeys.add(rowKey);
            }
        } else {
            Object rowKey = this.getRowKeyFromModel(object);
            if (rowKey != null) {
                this.selectedRowKeys.add(rowKey);
            }
        }
    }

    public List<Object> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    public String getSelectedRowKeysAsString() {
        StringBuilder builder = SharedStringBuilder.get(SB_GET_SELECTED_ROW_KEYS_AS_STRING);
        Iterator<Object> iter = this.getSelectedRowKeys().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public SummaryRow getSummaryRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    public HeaderRow getHeaderRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof HeaderRow)) continue;
            return (HeaderRow)kid;
        }
        return null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    int dynamicColumnsCount = ((Columns)kid).getRowCount();
                    if (dynamicColumnsCount <= 0) continue;
                    this.columnsCount += dynamicColumnsCount;
                    continue;
                }
                if (kid instanceof Column) {
                    if (!((UIColumn)kid).isVisible()) continue;
                    ++this.columnsCount;
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    ++this.columnsCount;
                }
            }
        }
        return this.columnsCount;
    }

    public int getColumnsCountWithSpan() {
        if (this.columnsCountWithSpan == -1) {
            this.columnsCountWithSpan = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    int dynamicColumnsCount = ((Columns)kid).getRowCount();
                    if (dynamicColumnsCount <= 0) continue;
                    this.columnsCountWithSpan += dynamicColumnsCount;
                    continue;
                }
                if (kid instanceof Column) {
                    Column col = (Column)kid;
                    if (!col.isVisible()) continue;
                    this.columnsCountWithSpan += col.getColspan();
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    this.columnsCountWithSpan += ((Column)subTableKid).getColspan();
                }
            }
        }
        return this.columnsCountWithSpan;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String paramValue = (String)params.get("primefaces.skipchildren");
        if (paramValue != null && !Boolean.valueOf(paramValue).booleanValue()) {
            return false;
        }
        return this.isSkipChildren() || params.containsKey(this.getClientId(context) + "_skipChildren");
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
        if (column == null) {
            this.getStateHelper().remove((Serializable)((Object)"sortColumnKey"));
        } else {
            this.getStateHelper().put((Serializable)((Object)"sortColumnKey"), (Object)column.getColumnKey());
        }
    }

    public UIColumn getSortColumn() {
        String sortColumnKey;
        if (this.sortColumn == null && (sortColumnKey = (String)this.getStateHelper().get((Serializable)((Object)"sortColumnKey"))) != null) {
            this.sortColumn = this.findColumn(sortColumnKey);
        }
        return this.sortColumn;
    }

    public boolean isMultiSort() {
        String sortMode = this.getSortMode();
        return sortMode != null && sortMode.equals("multiple");
    }

    public List<SortMeta> getMultiSortMeta() {
        if (this.multiSortMeta != null) {
            return this.multiSortMeta;
        }
        List multiSortStateList = (List)this.getStateHelper().get((Serializable)((Object)"multiSortState"));
        if (multiSortStateList != null && !multiSortStateList.isEmpty()) {
            this.multiSortMeta = new ArrayList<SortMeta>();
            for (int i = 0; i < multiSortStateList.size(); ++i) {
                MultiSortState multiSortState = (MultiSortState)multiSortStateList.get(i);
                SortMeta sortMeta = new SortMeta();
                sortMeta.setSortBy(this.findColumn(multiSortState.getSortKey()));
                sortMeta.setSortField(multiSortState.getSortField());
                sortMeta.setSortOrder(multiSortState.getSortOrder());
                sortMeta.setSortFunction(multiSortState.getSortFunction());
                this.multiSortMeta.add(sortMeta);
            }
        } else {
            ValueExpression ve = this.getValueExpression(PropertyKeys.sortBy.toString());
            if (ve != null) {
                this.multiSortMeta = (List)ve.getValue(this.getFacesContext().getELContext());
            }
        }
        return this.multiSortMeta;
    }

    public void setMultiSortMeta(List<SortMeta> value) {
        this.multiSortMeta = value;
        if (value != null && !value.isEmpty()) {
            ArrayList<MultiSortState> multiSortStateList = new ArrayList<MultiSortState>();
            for (int i = 0; i < value.size(); ++i) {
                multiSortStateList.add(new MultiSortState(value.get(i)));
            }
            this.getStateHelper().put((Serializable)((Object)"multiSortState"), multiSortStateList);
        }
    }

    private void clearMultiSortMeta() {
        this.multiSortMeta = null;
        this.getStateHelper().remove((Serializable)((Object)"multiSortState"));
    }

    @Override
    public boolean isRTL() {
        return this.getDir().equalsIgnoreCase("rtl");
    }

    public String resolveSelectionMode() {
        String tableSelectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        String selectionMode = null;
        if (tableSelectionMode != null) {
            selectionMode = tableSelectionMode;
        } else if (columnSelectionMode != null) {
            selectionMode = columnSelectionMode.equals("single") ? "radio" : "checkbox";
        }
        return selectionMode;
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    @Override
    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof UIColumn) {
                    if (child instanceof Column) {
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                        continue;
                    }
                    if (!(child instanceof Columns)) continue;
                    Columns uicolumns = (Columns)child;
                    int f = uicolumns.getFirst();
                    int r = uicolumns.getRows();
                    int l = r == 0 ? uicolumns.getRowCount() : f + r;
                    for (int i = f; i < l; ++i) {
                        uicolumns.setRowIndex(i);
                        if (!uicolumns.isRowAvailable()) break;
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                    }
                    uicolumns.setRowIndex(-1);
                    continue;
                }
                if (!(child instanceof ColumnGroup) || child.getChildCount() <= 0) continue;
                for (UIComponent columnGroupChild : child.getChildren()) {
                    if (columnGroupChild instanceof Row && columnGroupChild.getChildCount() > 0) {
                        for (UIComponent rowChild : columnGroupChild.getChildren()) {
                            if (rowChild instanceof Column && rowChild.getFacetCount() > 0) {
                                for (UIComponent facet : rowChild.getFacets().values()) {
                                    this.process(context, facet, phaseId);
                                }
                                continue;
                            }
                            this.process(context, rowChild, phaseId);
                        }
                        continue;
                    }
                    this.process(context, columnGroupChild, phaseId);
                }
            }
        }
    }

    public void setSortByVE(ValueExpression ve) {
        this.sortByVE = ve;
    }

    public ValueExpression getSortByVE() {
        return this.sortByVE;
    }

    public void setDefaultSortByVE(ValueExpression ve) {
        this.setValueExpression("defaultSortBy", ve);
    }

    public ValueExpression getDefaultSortByVE() {
        return this.getValueExpression("defaultSortBy");
    }

    public void setDefaultSortOrder(String val) {
        this.getStateHelper().put((Serializable)((Object)"defaultSortOrder"), (Object)val);
    }

    public String getDefaultSortOrder() {
        return (String)this.getStateHelper().get((Serializable)((Object)"defaultSortOrder"));
    }

    public void setDefaultSortFunction(MethodExpression obj) {
        this.getStateHelper().put((Serializable)((Object)"defaultSortFunction"), (Object)obj);
    }

    public MethodExpression getDefaultSortFunction() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)"defaultSortFunction"));
    }

    public void setDefaultSort(boolean defaultSort) {
        this.getStateHelper().put((Serializable)((Object)"defaultSort"), (Object)defaultSort);
    }

    public boolean isDefaultSort() {
        Object value = this.getStateHelper().get((Serializable)((Object)"defaultSort"));
        if (value == null) {
            return true;
        }
        return (Boolean)value;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        Object userLocale = this.getDataLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                return ComponentUtils.toLocale((String)userLocale);
            }
            if (userLocale instanceof Locale) {
                return (Locale)userLocale;
            }
            throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for datatable:" + this.getClientId(context));
        }
        return context.getViewRoot().getLocale();
    }

    private boolean isFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_filtering");
    }

    @Override
    protected List<UIComponent> getIterableChildren() {
        if (this.iterableChildren == null) {
            this.iterableChildren = new ArrayList<UIComponent>();
            for (UIComponent child : this.getChildren()) {
                if (child instanceof ColumnGroup) continue;
                this.iterableChildren.add(child);
            }
        }
        return this.iterableChildren;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        List filteredValue;
        super.processEvent(event);
        if (!this.isLazy() && event instanceof PostRestoreStateEvent && this == event.getComponent() && (filteredValue = this.getFilteredValue()) != null) {
            this.updateValue(filteredValue);
        }
    }

    public void updateFilteredValue(FacesContext context, List<?> value) {
        ValueExpression ve = this.getValueExpression(PropertyKeys.filteredValue.toString());
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        } else {
            this.setFilteredValue(value);
        }
    }

    public void updateValue(Object value) {
        Object originalValue = this.getValue();
        if (originalValue instanceof SelectableDataModel) {
            this.setValue(new SelectableDataModelWrapper((SelectableDataModel)originalValue, value));
        } else {
            this.setValue(value);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.isFilteringEnabled()) {
            this.setValue(null);
        }
        return super.saveState(context);
    }

    @Override
    protected void preDecode(FacesContext context) {
        this.resetDynamicColumns();
        super.preDecode(context);
    }

    @Override
    protected void preValidate(FacesContext context) {
        this.resetDynamicColumns();
        super.preValidate(context);
    }

    @Override
    protected void preUpdate(FacesContext context) {
        this.resetDynamicColumns();
        super.preUpdate(context);
    }

    @Override
    protected void preEncode(FacesContext context) {
        this.resetDynamicColumns();
        super.preEncode(context);
    }

    private void resetDynamicColumns() {
        Columns dynamicCols = this.getDynamicColumns();
        if (dynamicCols != null && this.isNestedWithinIterator().booleanValue()) {
            dynamicCols.setRowIndex(-1);
            this.setColumns(null);
        }
    }

    public void restoreTableState() {
        TableState ts = this.getTableState(false);
        if (ts != null) {
            if (this.isPaginator()) {
                this.setFirst(ts.getFirst());
                int rows = ts.getRows() == 0 ? this.getRows() : ts.getRows();
                this.setRows(rows);
            }
            this.setMultiSortMeta(ts.getMultiSortMeta());
            this.setValueExpression("sortBy", ts.getSortBy());
            this.setSortOrder(ts.getSortOrder());
            this.setSortFunction(ts.getSortFunction());
            this.setSortField(ts.getSortField());
            this.setDefaultSort(false);
            this.setDefaultSortByVE(ts.getDefaultSortBy());
            this.setDefaultSortOrder(ts.getDefaultSortOrder());
            this.setDefaultSortFunction(ts.getDefaultSortFunction());
            if (this.isSelectionEnabled()) {
                this.selectedRowKeys = ts.getRowKeys();
            }
            this.setFilterBy(ts.getFilters());
            this.setGlobalFilter(ts.getGlobalFilterValue());
        }
    }

    public TableState getTableState(boolean create) {
        TableState ts;
        FacesContext fc = this.getFacesContext();
        Map sessionMap = fc.getExternalContext().getSessionMap();
        HashMap<String, TableState> dtState = (HashMap<String, TableState>)sessionMap.get("primefaces.TABLE_STATE");
        String viewId = fc.getViewRoot().getViewId().replaceFirst("^/*", "");
        String stateKey = viewId + "_" + this.getClientId(fc);
        if (dtState == null) {
            dtState = new HashMap<String, TableState>();
            sessionMap.put("primefaces.TABLE_STATE", dtState);
        }
        if ((ts = (TableState)dtState.get(stateKey)) == null && create) {
            ts = new TableState();
            dtState.put(stateKey, ts);
        }
        return ts;
    }

    public String getGroupedColumnIndexes() {
        List<UIColumn> columns = this.getColumns();
        int size = columns.size();
        boolean hasIndex = false;
        if (size > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < size; ++i) {
                UIColumn column = columns.get(i);
                if (!column.isGroupRow()) continue;
                if (hasIndex) {
                    sb.append(",");
                }
                sb.append(i);
                hasIndex = true;
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    @Override
    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    static {
        FEATURES.put(DataTableFeatureKey.DRAGGABLE_COLUMNS, new DraggableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.FILTER, new FilterFeature());
        FEATURES.put(DataTableFeatureKey.PAGE, new PageFeature());
        FEATURES.put(DataTableFeatureKey.SORT, new SortFeature());
        FEATURES.put(DataTableFeatureKey.RESIZABLE_COLUMNS, new ResizableColumnsFeature());
        FEATURES.put(DataTableFeatureKey.SELECT, new SelectionFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EDIT, new RowEditFeature());
        FEATURES.put(DataTableFeatureKey.CELL_EDIT, new CellEditFeature());
        FEATURES.put(DataTableFeatureKey.ROW_EXPAND, new RowExpandFeature());
        FEATURES.put(DataTableFeatureKey.SCROLL, new ScrollFeature());
        FEATURES.put(DataTableFeatureKey.DRAGGABLE_ROWS, new DraggableRowsFeature());
        FEATURES.put(DataTableFeatureKey.ADD_ROW, new AddRowFeature());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        widgetVar,
        scrollable,
        scrollHeight,
        scrollWidth,
        selectionMode,
        selection,
        emptyMessage,
        style,
        styleClass,
        liveScroll,
        rowStyleClass,
        onExpandStart,
        resizableColumns,
        sortBy,
        sortOrder,
        sortFunction,
        scrollRows,
        rowKey,
        filterEvent,
        filterDelay,
        tableStyle,
        tableStyleClass,
        draggableColumns,
        editable,
        filteredValue,
        sortMode,
        editMode,
        editingRow,
        cellSeparator,
        summary,
        frozenRows,
        dir,
        liveResize,
        stickyHeader,
        expandedRow,
        disabledSelection,
        rowSelectMode,
        rowExpandMode,
        dataLocale,
        nativeElements,
        frozenColumns,
        draggableRows,
        caseSensitiveSort,
        skipChildren,
        disabledTextSelection,
        sortField,
        initMode,
        nullSortOrder,
        tabindex,
        reflow,
        liveScrollBuffer,
        rowHover,
        resizeMode,
        ariaRowLabel,
        saveOnCellBlur,
        clientCache,
        multiViewState,
        filterBy,
        globalFilter,
        cellEditMode,
        expandableRowGroups,
        virtualScroll;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

