/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class RowEditFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("RowEditFeature should not encode.");
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        if (table.isSelectionEnabled()) {
            table.findSelectedRowKeys();
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        int editedRowId = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
        String action = (String)params.get(clientId + "_rowEditAction");
        table.setRowIndex(editedRowId);
        if (action.equals("cancel")) {
            VisitContext visitContext = null;
            for (UIColumn column : table.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    if (!(grandkid instanceof CellEditor)) continue;
                    UIComponent inputFacet = grandkid.getFacet("input");
                    if (inputFacet instanceof EditableValueHolder) {
                        ((EditableValueHolder)inputFacet).resetValue();
                        continue;
                    }
                    if (visitContext == null) {
                        visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                    }
                    inputFacet.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                }
            }
        }
        if (table.isRowAvailable()) {
            renderer.encodeRow(context, table, clientId, editedRowId);
        }
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowEditAction");
    }
}

