/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.model.LazyDataModel;

public class RowExpandFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("RowExpandFeature should not encode.");
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int expandedRowIndex = Integer.parseInt((String)params.get(table.getClientId(context) + "_expandedRowIndex"));
        if (table.isLazy() && ((LazyDataModel)table.getValue()).getWrappedData() == null) {
            table.loadLazyData();
        }
        this.encodeExpansion(context, renderer, table, expandedRowIndex);
        table.setRowIndex(-1);
    }

    public void encodeExpansion(FacesContext context, DataTableRenderer renderer, DataTable table, int rowIndex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        RowExpansion rowExpansion = table.getRowExpansion();
        String styleClass = "ui-expanded-row-content ui-widget-content";
        if (rowExpansion.getStyleClass() != null) {
            styleClass = styleClass + " " + rowExpansion.getStyleClass();
        }
        table.setRowIndex(rowIndex);
        if (rowExpansion.isRendered()) {
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
            }
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
            table.getRowExpansion().encodeAll(context);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowExpansion");
    }
}

