/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.context.RequestContext;
import org.primefaces.event.data.PostSortEvent;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.ChainedBeanPropertyComparator;
import org.primefaces.model.DynamicChainedPropertyComparator;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class SortFeature
implements DataTableFeature {
    private boolean isSortRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    public void decode(FacesContext context, DataTable table) {
        table.setRowIndex(-1);
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        if (table.isMultiSort()) {
            ArrayList<SortMeta> multiSortMeta = new ArrayList<SortMeta>();
            String[] sortKeys = sortKey.split(",");
            String[] sortOrders = sortDir.split(",");
            for (int i = 0; i < sortKeys.length; ++i) {
                String sortField;
                String field;
                UIColumn sortColumn = table.findColumn(sortKeys[i]);
                ValueExpression columnSortByVE = sortColumn.getValueExpression(Column.PropertyKeys.sortBy.toString());
                if (sortColumn.isDynamic()) {
                    ((DynamicColumn)sortColumn).applyStatelessModel();
                    field = sortColumn.getField();
                    sortField = field == null ? table.resolveDynamicField(columnSortByVE) : field;
                } else {
                    field = sortColumn.getField();
                    sortField = field == null ? table.resolveStaticField(columnSortByVE) : field;
                }
                multiSortMeta.add(new SortMeta(sortColumn, sortField, SortOrder.valueOf(this.convertSortOrderParam(sortOrders[i])), sortColumn.getSortFunction()));
            }
            table.setMultiSortMeta(multiSortMeta);
        } else {
            UIColumn sortColumn = table.findColumn(sortKey);
            ValueExpression sortByVE = sortColumn.getValueExpression(Column.PropertyKeys.sortBy.toString());
            table.setValueExpression(DataTable.PropertyKeys.sortBy.toString(), sortByVE);
            table.setSortColumn(sortColumn);
            table.setSortFunction(sortColumn.getSortFunction());
            table.setSortOrder(this.convertSortOrderParam(sortDir));
            table.setSortField(sortColumn.getField());
        }
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        table.setFirst(0);
        if (table.isLazy()) {
            table.loadLazyData();
        } else {
            RequestContext requestContext;
            if (table.isMultiSort()) {
                this.multiSort(context, table);
            } else {
                this.singleSort(context, table);
            }
            if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", table.getRowCount());
            }
            List filteredValue = table.getFilteredValue();
            if (!table.isLazy() && table.isFilteringEnabled() && filteredValue != null) {
                table.updateFilteredValue(context, filteredValue);
            }
        }
        renderer.encodeTbody(context, table, true);
        if (table.isMultiViewState()) {
            String sortField = table.getSortField();
            ValueExpression sortVE = sortField != null ? context.getApplication().getExpressionFactory().createValueExpression((Object)("#{'" + sortField + "'}"), String.class) : table.getValueExpression(DataTable.PropertyKeys.sortBy.toString());
            List<SortMeta> multiSortMeta = table.getMultiSortMeta();
            if (sortVE != null || multiSortMeta != null) {
                TableState ts = table.getTableState(true);
                ts.setSortBy(sortVE);
                ts.setMultiSortMeta(multiSortMeta);
                ts.setSortOrder(table.getSortOrder());
                ts.setSortField(table.getSortField());
                ts.setSortFunction(table.getSortFunction());
                if (table.isPaginator()) {
                    ts.setFirst(table.getFirst());
                    ts.setRows(table.getRows());
                }
            }
        }
    }

    public void singleSort(FacesContext context, DataTable table) {
        Object value = table.getValue();
        if (value == null) {
            return;
        }
        String sortField = table.getSortField();
        ValueExpression sortVE = sortField != null ? context.getApplication().getExpressionFactory().createValueExpression((Object)("#{'" + sortField + "'}"), String.class) : table.getValueExpression(DataTable.PropertyKeys.sortBy.toString());
        SortOrder sortOrder = SortOrder.valueOf(table.getSortOrder().toUpperCase(Locale.ENGLISH));
        MethodExpression sortFunction = table.getSortFunction();
        List list = null;
        UIColumn sortColumn = table.getSortColumn();
        if (sortColumn != null && sortColumn.isDynamic()) {
            ((DynamicColumn)sortColumn).applyStatelessModel();
        }
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        Collections.sort(list, new BeanPropertyComparator(sortVE, table.getVar(), sortOrder, sortFunction, table.isCaseSensitiveSort(), table.resolveDataLocale(), table.getNullSortOrder()));
        context.getApplication().publishEvent(context, PostSortEvent.class, (Object)table);
    }

    public void multiSort(FacesContext context, DataTable table) {
        Object value = table.getValue();
        List<SortMeta> sortMeta = table.getMultiSortMeta();
        List list = null;
        boolean caseSensitiveSort = table.isCaseSensitiveSort();
        Locale locale = table.resolveDataLocale();
        int nullSortOrder = table.getNullSortOrder();
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        ChainedBeanPropertyComparator chainedComparator = new ChainedBeanPropertyComparator();
        for (SortMeta meta : sortMeta) {
            BeanPropertyComparator comparator;
            UIColumn sortColumn = meta.getColumn();
            ValueExpression sortByVE = sortColumn.getValueExpression(Column.PropertyKeys.sortBy.toString());
            if (sortColumn.isDynamic()) {
                ((DynamicColumn)sortColumn).applyStatelessModel();
                comparator = new DynamicChainedPropertyComparator((DynamicColumn)sortColumn, sortByVE, table.getVar(), meta.getSortOrder(), sortColumn.getSortFunction(), caseSensitiveSort, locale, nullSortOrder);
            } else {
                comparator = new BeanPropertyComparator(sortByVE, table.getVar(), meta.getSortOrder(), sortColumn.getSortFunction(), caseSensitiveSort, locale, nullSortOrder);
            }
            chainedComparator.addComparator(comparator);
        }
        Collections.sort(list, chainedComparator);
        context.getApplication().publishEvent(context, PostSortEvent.class, (Object)table);
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    public String convertSortOrderParam(String order) {
        String sortOrder = null;
        int orderNumber = Integer.parseInt(order);
        switch (orderNumber) {
            case 0: {
                sortOrder = "UNSORTED";
                break;
            }
            case 1: {
                sortOrder = "ASCENDING";
                break;
            }
            case -1: {
                sortOrder = "DESCENDING";
            }
        }
        return sortOrder;
    }
}

