/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.event.DragDropEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Droppable
extends UIComponentBase
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Droppable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.DroppableRenderer";
    private static final String DEFAULT_EVENT = "drop";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put(Droppable.DEFAULT_EVENT, null);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    public Droppable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getFor() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.forValue), null);
    }

    public void setFor(String _for) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forValue), (Object)_for);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), (Object)false);
    }

    public void setDisabled(boolean _disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), (Object)_disabled);
    }

    public String getHoverStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.hoverStyleClass), null);
    }

    public void setHoverStyleClass(String _hoverStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.hoverStyleClass), (Object)_hoverStyleClass);
    }

    public String getActiveStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.activeStyleClass), null);
    }

    public void setActiveStyleClass(String _activeStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.activeStyleClass), (Object)_activeStyleClass);
    }

    public String getOnDrop() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onDrop), null);
    }

    public void setOnDrop(String _onDrop) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onDrop), (Object)_onDrop);
    }

    public String getAccept() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.accept), null);
    }

    public void setAccept(String _accept) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.accept), (Object)_accept);
    }

    public String getScope() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scope), null);
    }

    public void setScope(String _scope) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scope), (Object)_scope);
    }

    public String getTolerance() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tolerance), null);
    }

    public void setTolerance(String _tolerance) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tolerance), (Object)_tolerance);
    }

    public String getDatasource() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.datasource), null);
    }

    public void setDatasource(String _datasource) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.datasource), (Object)_datasource);
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals(DEFAULT_EVENT)) {
                String dragId = (String)params.get(clientId + "_dragId");
                String dropId = (String)params.get(clientId + "_dropId");
                DragDropEvent dndEvent = null;
                String datasourceId = this.getDatasource();
                if (datasourceId != null) {
                    UIData datasource = this.findDatasource(context, this, datasourceId);
                    String[] idTokens = dragId.split(String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
                    int rowIndex = Integer.parseInt(idTokens[idTokens.length - 2]);
                    datasource.setRowIndex(rowIndex);
                    Object data = datasource.getRowData();
                    datasource.setRowIndex(-1);
                    dndEvent = new DragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), dragId, dropId, data);
                } else {
                    dndEvent = new DragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), dragId, dropId);
                }
                super.queueEvent((FacesEvent)dndEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    protected UIData findDatasource(FacesContext context, Droppable droppable, String datasourceId) {
        UIComponent datasource = SearchExpressionFacade.resolveComponent(context, (UIComponent)droppable, datasourceId);
        if (datasource == null) {
            throw new FacesException("Cannot find component \"" + datasourceId + "\" in view.");
        }
        return (UIData)datasource;
    }

    @Override
    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        widgetVar,
        forValue("for"),
        disabled,
        hoverStyleClass,
        activeStyleClass,
        onDrop,
        accept,
        scope,
        tolerance,
        datasource;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

