/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.awt.Color;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.primefaces.component.export.ExcelExporter;
import org.primefaces.component.export.ExporterOptions;

public class ExcelXExporter
extends ExcelExporter {
    protected Workbook createWorkBook() {
        return new XSSFWorkbook();
    }

    protected RichTextString createRichTextString(String value) {
        return new XSSFRichTextString(value);
    }

    protected String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    }

    protected String getContentDisposition(String filename) {
        return "attachment;filename=" + filename + ".xlsx";
    }

    protected void applyFacetOptions(Workbook wb, ExporterOptions options, CellStyle facetStyle) {
        Font facetFont = wb.createFont();
        facetFont.setFontName("Arial");
        if (options != null) {
            String facetFontSize;
            String facetFontColor;
            String facetBackground;
            String facetFontStyle = options.getFacetFontStyle();
            if (facetFontStyle != null) {
                if (facetFontStyle.equalsIgnoreCase("BOLD")) {
                    facetFont.setBoldweight((short)700);
                }
                if (facetFontStyle.equalsIgnoreCase("ITALIC")) {
                    facetFont.setItalic(true);
                }
            }
            if ((facetBackground = options.getFacetBgColor()) != null) {
                XSSFColor backgroundColor = new XSSFColor(Color.decode(facetBackground));
                ((XSSFCellStyle)facetStyle).setFillForegroundColor(backgroundColor);
                facetStyle.setFillPattern((short)1);
            }
            if ((facetFontColor = options.getFacetFontColor()) != null) {
                XSSFColor facetColor = new XSSFColor(Color.decode(facetFontColor));
                ((XSSFFont)facetFont).setColor(facetColor);
            }
            if ((facetFontSize = options.getFacetFontSize()) != null) {
                facetFont.setFontHeightInPoints(Short.valueOf(facetFontSize).shortValue());
            }
        }
        facetStyle.setFont(facetFont);
    }

    protected void applyCellOptions(Workbook wb, ExporterOptions options, CellStyle cellStyle) {
        Font cellFont = wb.createFont();
        cellFont.setFontName("Arial");
        if (options != null) {
            String cellFontStyle;
            String cellFontSize;
            String cellFontColor = options.getCellFontColor();
            if (cellFontColor != null) {
                XSSFColor cellColor = new XSSFColor(Color.decode(cellFontColor));
                ((XSSFFont)cellFont).setColor(cellColor);
            }
            if ((cellFontSize = options.getCellFontSize()) != null) {
                cellFont.setFontHeightInPoints(Short.valueOf(cellFontSize).shortValue());
            }
            if ((cellFontStyle = options.getCellFontStyle()) != null) {
                if (cellFontStyle.equalsIgnoreCase("BOLD")) {
                    cellFont.setBoldweight((short)700);
                }
                if (cellFontStyle.equalsIgnoreCase("ITALIC")) {
                    cellFont.setItalic(true);
                }
            }
        }
        cellStyle.setFont(cellFont);
    }
}

