/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imagecropper;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.imageio.ImageIO;
import org.primefaces.component.imagecropper.ImageCropper;
import org.primefaces.model.CroppedImage;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ImageCropperRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String coordsParam;
        ImageCropper cropper = (ImageCropper)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(coordsParam = cropper.getClientId(context) + "_coords")) {
            cropper.setSubmittedValue(params.get(coordsParam));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ImageCropper cropper = (ImageCropper)component;
        this.encodeMarkup(context, cropper);
        this.encodeScript(context, cropper);
    }

    protected void encodeScript(FacesContext context, ImageCropper cropper) throws IOException {
        String widgetVar = cropper.resolveWidgetVar();
        String clientId = cropper.getClientId(context);
        String image = clientId + "_image";
        String select = null;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithComponentLoad("ImageCropper", widgetVar, clientId, clientId + "_image").attr("image", image);
        if (cropper.getMinSize() != null) {
            wb.append(",minSize:[").append(cropper.getMinSize()).append("]");
        }
        if (cropper.getMaxSize() != null) {
            wb.append(",maxSize:[").append(cropper.getMaxSize()).append("]");
        }
        wb.attr("bgColor", cropper.getBackgroundColor(), null).attr("bgOpacity", cropper.getBackgroundOpacity(), 0.6).attr("aspectRatio", cropper.getAspectRatio(), Double.MIN_VALUE).attr("boxWidth", cropper.getBoxWidth(), 0).attr("boxHeight", cropper.getBoxHeight(), 0);
        Object value = cropper.getValue();
        if (value != null) {
            CroppedImage croppedImage = (CroppedImage)value;
            int x = croppedImage.getLeft();
            int y = croppedImage.getTop();
            int x2 = x + croppedImage.getWidth();
            int y2 = y + croppedImage.getHeight();
            select = "[" + x + "," + y + "," + x2 + "," + y2 + "]";
        } else if (cropper.getInitialCoords() != null) {
            select = "[" + cropper.getInitialCoords() + "]";
        }
        wb.append(",setSelect:").append(select);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, ImageCropper cropper) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cropper.getClientId(context);
        String coordsHolderId = clientId + "_coords";
        writer.startElement("div", (UIComponent)cropper);
        writer.writeAttribute("id", (Object)clientId, null);
        this.renderImage(context, cropper, clientId);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)coordsHolderId, null);
        writer.writeAttribute("name", (Object)coordsHolderId, null);
        writer.endElement("input");
        writer.endElement("div");
    }

    private void renderImage(FacesContext context, ImageCropper cropper, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String alt = cropper.getAlt() == null ? "" : cropper.getAlt();
        writer.startElement("img", null);
        writer.writeAttribute("id", (Object)(clientId + "_image"), null);
        writer.writeAttribute("alt", (Object)alt, null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, cropper.getImage()), null);
        writer.endElement("img");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String coords = (String)submittedValue;
        if (this.isValueBlank(coords)) {
            return null;
        }
        String[] cropCoords = coords.split("_");
        int x = (int)Double.parseDouble(cropCoords[0]);
        int y = (int)Double.parseDouble(cropCoords[1]);
        int w = (int)Double.parseDouble(cropCoords[2]);
        int h = (int)Double.parseDouble(cropCoords[3]);
        if (w <= 0 || h <= 0) {
            return null;
        }
        ImageCropper cropper = (ImageCropper)component;
        Resource resource = this.getImageResource(context, cropper);
        String imagePath = cropper.getImage();
        String contentType = null;
        try {
            InputStream inputStream;
            if (resource != null && !"RES_NOT_FOUND".equals(resource.toString())) {
                inputStream = resource.getInputStream();
                contentType = resource.getContentType();
            } else {
                boolean isExternal = imagePath.startsWith("http");
                if (isExternal) {
                    URL url = new URL(imagePath);
                    URLConnection urlConnection = url.openConnection();
                    inputStream = urlConnection.getInputStream();
                    contentType = urlConnection.getContentType();
                } else {
                    ExternalContext externalContext = context.getExternalContext();
                    File file = new File(externalContext.getRealPath("") + imagePath);
                    inputStream = new FileInputStream(file);
                }
            }
            BufferedImage outputImage = ImageIO.read(inputStream);
            inputStream.close();
            BufferedImage cropped = outputImage.getSubimage(x, y, w, h);
            ByteArrayOutputStream croppedOutImage = new ByteArrayOutputStream();
            String format = this.guessImageFormat(contentType, imagePath);
            ImageIO.write((RenderedImage)cropped, format, croppedOutImage);
            return new CroppedImage(cropper.getImage(), croppedOutImage.toByteArray(), x, y, w, h);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private Resource getImageResource(FacesContext facesContext, ImageCropper imageCropper) {
        String imageValueExpressionString;
        Resource resource = null;
        ValueExpression imageValueExpression = imageCropper.getValueExpression(ImageCropper.PropertyKeys.image.toString());
        if (imageValueExpression != null && (imageValueExpressionString = imageValueExpression.getExpressionString()).matches("^[#][{]resource\\['[^']+'\\][}]$")) {
            String resourceName;
            imageValueExpressionString = imageValueExpressionString.replaceFirst("^[#][{]resource\\['", "");
            imageValueExpressionString = imageValueExpressionString.replaceFirst("'\\][}]$", "");
            String resourceLibrary = null;
            String[] resourceInfo = imageValueExpressionString.split(":");
            if (resourceInfo.length == 2) {
                resourceLibrary = resourceInfo[0];
                resourceName = resourceInfo[1];
            } else {
                resourceName = resourceInfo[0];
            }
            if (resourceName != null) {
                Application application = facesContext.getApplication();
                ResourceHandler resourceHandler = application.getResourceHandler();
                resource = resourceLibrary != null ? resourceHandler.createResource(resourceName, resourceLibrary) : resourceHandler.createResource(resourceName);
            }
        }
        return resource;
    }

    private String guessImageFormat(String contentType, String imagePath) throws IOException {
        String format = "png";
        if (contentType == null) {
            contentType = URLConnection.guessContentTypeFromName(imagePath);
        }
        if (contentType != null) {
            format = contentType.replaceFirst("^image/([^;]+)[;]?.*$", "$1");
        } else {
            String[] pathTokens;
            int queryStringIndex = imagePath.indexOf(63);
            if (queryStringIndex != -1) {
                imagePath = imagePath.substring(0, queryStringIndex);
            }
            if ((pathTokens = imagePath.split("\\.")).length > 1) {
                format = pathTokens[pathTokens.length - 1];
            }
        }
        return format;
    }
}

