/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputnumber;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputnumber.InputNumber;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class InputNumberRenderer
extends InputRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String submittedValueString = (String)submittedValue;
        if (ComponentUtils.isValueBlank(submittedValueString)) {
            return null;
        }
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, component, submittedValueString);
        }
        return submittedValue;
    }

    public void decode(FacesContext context, UIComponent component) {
        InputNumber inputNumber = (InputNumber)component;
        if (inputNumber.isDisabled() || inputNumber.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputNumber);
        String inputId = inputNumber.getClientId(context) + "_hinput";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputNumber.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputNumber inputNumber = (InputNumber)component;
        Object value = inputNumber.getValue();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputNumber, value);
        if (valueToRender == null) {
            valueToRender = "";
        }
        this.encodeMarkup(context, inputNumber, value, valueToRender);
        this.encodeScript(context, inputNumber, value, valueToRender);
    }

    protected void encodeMarkup(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        String styleClass = inputNumber.getStyleClass();
        styleClass = styleClass == null ? "ui-inputnumber ui-widget" : "ui-inputnumber ui-widget " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputNumber.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputNumber.getStyle(), "style");
        }
        this.encodeInput(context, inputNumber, clientId, valueToRender);
        this.encodeHiddenInput(context, inputNumber, clientId);
        writer.endElement("span");
    }

    protected void encodeHiddenInput(FacesContext context, InputNumber inputNumber, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_hinput";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (inputNumber.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)inputNumber.getOnchange(), null);
        }
        if (inputNumber.getOnkeydown() != null) {
            writer.writeAttribute("onkeydown", (Object)inputNumber.getOnkeydown(), null);
        }
        if (inputNumber.getOnkeyup() != null) {
            writer.writeAttribute("onkeyup", (Object)inputNumber.getOnkeyup(), null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)inputNumber);
        }
        writer.endElement("input");
    }

    protected void encodeInput(FacesContext context, InputNumber inputNumber, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String inputStyle = inputNumber.getInputStyle();
        String inputStyleClass = inputNumber.getInputStyleClass();
        String style = inputStyle;
        String styleClass = "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
        styleClass = inputNumber.isValid() ? styleClass : styleClass + " ui-state-error";
        String string = styleClass = !inputNumber.isDisabled() ? styleClass : styleClass + " ui-state-disabled";
        if (!this.isValueBlank(inputStyleClass)) {
            styleClass = styleClass + " " + inputStyleClass;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputNumber.getType(), null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        this.renderPassThruAttributes(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_EVENTS);
        if (inputNumber.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (inputNumber.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (!this.isValueBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)inputNumber);
        }
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        WidgetBuilder wb = RequestContext.getCurrentInstance().getWidgetBuilder();
        wb.initWithDomReady(InputNumber.class.getSimpleName(), inputNumber.resolveWidgetVar(), inputNumber.getClientId());
        wb.attr("disabled", inputNumber.isDisabled()).attr("valueToRender", this.formatForPlugin(valueToRender, inputNumber, value));
        String metaOptions = this.getOptions(inputNumber);
        if (!metaOptions.isEmpty()) {
            wb.nativeAttr("pluginOptions", metaOptions);
        }
        wb.finish();
    }

    protected String getOptions(InputNumber inputNumber) {
        String decimalSeparator = inputNumber.getDecimalSeparator();
        String thousandSeparator = inputNumber.getThousandSeparator();
        String symbol = inputNumber.getSymbol();
        String symbolPosition = inputNumber.getSymbolPosition();
        String minValue = inputNumber.getMinValue();
        String maxValue = inputNumber.getMaxValue();
        String roundMethod = inputNumber.getRoundMethod();
        String decimalPlaces = inputNumber.getDecimalPlaces();
        String emptyValue = inputNumber.getEmptyValue();
        boolean padControl = inputNumber.isPadControl();
        String options = "";
        options = options + (this.isValueBlank(decimalSeparator) ? "" : "aDec:\"" + this.escapeText(decimalSeparator) + "\",");
        options = options + (this.isValueBlank(thousandSeparator) ? "aSep:''," : "aSep:\"" + this.escapeText(thousandSeparator) + "\",");
        options = options + (this.isValueBlank(symbol) ? "" : "aSign:\"" + this.escapeText(symbol) + "\",");
        options = options + (this.isValueBlank(symbolPosition) ? "" : "pSign:\"" + this.escapeText(symbolPosition) + "\",");
        options = options + (this.isValueBlank(minValue) ? "" : "vMin:\"" + this.escapeText(minValue) + "\",");
        options = options + (this.isValueBlank(maxValue) ? "" : "vMax:\"" + this.escapeText(maxValue) + "\",");
        options = options + (this.isValueBlank(roundMethod) ? "" : "mRound:\"" + this.escapeText(roundMethod) + "\",");
        options = options + (this.isValueBlank(decimalPlaces) ? "" : "mDec:\"" + this.escapeText(decimalPlaces) + "\",");
        options = options + "wEmpty:\"" + this.escapeText(emptyValue) + "\",";
        if ((options = options + "aPad:" + padControl + ",").isEmpty()) {
            return "";
        }
        int lastInd = options.length() - 1;
        if (options.charAt(lastInd) == ',') {
            options = options.substring(0, lastInd);
        }
        return "{" + options + "}";
    }

    private String formatForPlugin(String valueToRender, InputNumber inputNumber, Object value) {
        if (this.isValueBlank(valueToRender)) {
            return "";
        }
        try {
            Number objectToRender = value instanceof BigDecimal || this.doubleValueCheck(valueToRender) ? new BigDecimal(valueToRender) : new Double(valueToRender);
            DecimalFormat formatter = new DecimalFormat("#0.0#");
            ((NumberFormat)formatter).setRoundingMode(RoundingMode.FLOOR);
            ((NumberFormat)formatter).setMinimumFractionDigits(15);
            ((NumberFormat)formatter).setMaximumFractionDigits(15);
            ((NumberFormat)formatter).setMaximumIntegerDigits(20);
            String f = formatter.format(objectToRender);
            f = f.replace(',', '.');
            return f;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a double value;", e);
        }
    }

    protected boolean doubleValueCheck(String valueToRender) {
        int counter = 0;
        int length = valueToRender.length();
        for (int i = 0; i < length; ++i) {
            if (valueToRender.charAt(i) != '9') continue;
            ++counter;
        }
        return counter > 15 || length > 15;
    }

    protected String getHighlighter() {
        return "inputnumber";
    }
}

