/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputswitch;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputswitch.InputSwitch;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class InputSwitchRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputSwitch inputSwitch = (InputSwitch)component;
        if (inputSwitch.isDisabled()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputSwitch);
        String clientId = inputSwitch.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (submittedValue != null && this.isChecked(submittedValue)) {
            inputSwitch.setSubmittedValue(true);
        } else {
            inputSwitch.setSubmittedValue(false);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputSwitch inputSwitch = (InputSwitch)component;
        this.encodeMarkup(context, inputSwitch);
        this.encodeScript(context, inputSwitch);
    }

    protected void encodeMarkup(FacesContext context, InputSwitch inputSwitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean checked = Boolean.valueOf(ComponentUtils.getValueToRender(context, (UIComponent)inputSwitch));
        boolean disabled = inputSwitch.isDisabled();
        boolean showLabels = inputSwitch.isShowLabels();
        String clientId = inputSwitch.getClientId(context);
        String style = inputSwitch.getStyle();
        String styleClass = inputSwitch.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-inputswitch ui-widget ui-widget-content ui-corner-all" : "ui-inputswitch ui-widget ui-widget-content ui-corner-all " + styleClass;
        if (inputSwitch.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)inputSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeOption(context, inputSwitch.getOffLabel(), "ui-inputswitch-off", showLabels);
        this.encodeOption(context, inputSwitch.getOnLabel(), "ui-inputswitch-on ui-state-active", showLabels);
        this.encodeHandle(context);
        this.encodeInput(context, inputSwitch, clientId, checked, disabled);
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, String label, String styleClass, boolean showLabels) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        if (showLabels) {
            writer.writeText((Object)label, null);
        } else {
            writer.write("&nbsp;");
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeHandle(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-inputswitch-handle ui-state-default ", null);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, InputSwitch inputSwitch, String clientId, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)inputSwitch);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputSwitch.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)inputSwitch.getTabindex(), null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)inputSwitch);
        }
        this.renderOnchange(context, (UIComponent)inputSwitch);
        this.renderDomEvents(context, (UIComponent)inputSwitch, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, InputSwitch inputSwitch) throws IOException {
        String clientId = inputSwitch.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputSwitch", inputSwitch.resolveWidgetVar(), clientId).finish();
    }

    protected boolean isChecked(String value) {
        return value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }
}

