/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.paginator;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.util.MessageFactory;

public class RowsPerPageDropdownRenderer
implements PaginatorElementRenderer {
    private static final Logger logger = Logger.getLogger(RowsPerPageDropdownRenderer.class.getName());

    public void render(FacesContext context, Pageable pageable) throws IOException {
        String template = pageable.getRowsPerPageTemplate();
        UIViewRoot viewroot = context.getViewRoot();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        if (template != null) {
            ResponseWriter writer = context.getResponseWriter();
            int actualRows = pageable.getRows();
            String[] options = pageable.getRowsPerPageTemplate().split("[,\\s]+");
            String label = pageable.getRowsPerPageLabel();
            if (label != null) {
                logger.info("RowsPerPageLabel attribute is deprecated, use 'primefaces.paginator.aria.ROWS_PER_PAGE' key instead to override default message.");
            } else {
                label = MessageFactory.getMessage("primefaces.paginator.aria.ROWS_PER_PAGE", null);
            }
            String clientId = pageable.getClientId(context);
            String ddId = clientId + separator + viewroot.createUniqueId();
            String ddName = clientId + "_rppDD";
            String labelId = null;
            if (label != null) {
                labelId = clientId + "_rppLabel";
                writer.startElement("label", null);
                writer.writeAttribute("id", (Object)labelId, null);
                writer.writeAttribute("for", (Object)ddId, null);
                writer.writeAttribute("class", (Object)"ui-paginator-rpp-label ui-helper-hidden", null);
                writer.writeText((Object)label, null);
                writer.endElement("label");
            }
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)ddId, null);
            writer.writeAttribute("name", (Object)ddName, null);
            if (label != null) {
                writer.writeAttribute("aria-labelledby", (Object)labelId, null);
            }
            writer.writeAttribute("class", (Object)"ui-paginator-rpp-options ui-widget ui-state-default ui-corner-left", null);
            writer.writeAttribute("value", (Object)pageable.getRows(), null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            for (String option : options) {
                int rows = Integer.parseInt(option);
                writer.startElement("option", null);
                writer.writeAttribute("value", (Object)rows, null);
                if (actualRows == rows) {
                    writer.writeAttribute("selected", (Object)"selected", null);
                }
                writer.writeText((Object)option, null);
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }
}

