/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rowtoggler;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.rowtoggler.RowToggler;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.MessageFactory;

public class RowTogglerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RowToggler toggler = (RowToggler)component;
        DataTable parentTable = toggler.getParentTable(context);
        boolean expanded = parentTable.isExpandedRow();
        String icon = expanded ? "ui-icon ui-icon-circle-triangle-s" : "ui-icon ui-icon-circle-triangle-e";
        String expandLabel = toggler.getExpandLabel();
        String collapseLabel = toggler.getCollapseLabel();
        boolean iconOnly = expandLabel == null && collapseLabel == null;
        String togglerClass = iconOnly ? "ui-row-toggler " + icon : "ui-row-toggler";
        String ariaLabel = MessageFactory.getMessage("primefaces.rowtoggler.aria.ROW_TOGGLER", null);
        writer.startElement("div", (UIComponent)toggler);
        writer.writeAttribute("class", (Object)togglerClass, null);
        writer.writeAttribute("tabindex", (Object)toggler.getTabindex(), null);
        writer.writeAttribute("role", (Object)"button", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        if (!iconOnly) {
            this.writeLabel(writer, expandLabel, !expanded);
            this.writeLabel(writer, collapseLabel, expanded);
        }
        writer.endElement("div");
    }

    protected void writeLabel(ResponseWriter writer, String label, boolean visible) throws IOException {
        writer.startElement("span", null);
        if (!visible) {
            writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        }
        writer.writeText((Object)label, null);
        writer.endElement("span");
    }
}

