/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.socket;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.socket.Socket;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SocketRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Socket socket = (Socket)component;
        String channel = socket.getChannel();
        String channelUrl = "/primepush" + channel;
        String url = this.getResourceURL(context, channelUrl);
        String pushServer = RequestContext.getCurrentInstance().getApplicationContext().getConfig().getPushServerURL();
        String clientId = socket.getClientId(context);
        if (pushServer != null) {
            url = pushServer + url;
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Socket", socket.resolveWidgetVar(), clientId);
        wb.attr("url", url).attr("autoConnect", socket.isAutoConnect()).attr("transport", socket.getTransport()).attr("fallbackTransport", socket.getFallbackTransport()).callback("onMessage", socket.getOnMessage()).callback("onError", "function(response)", socket.getOnError()).callback("onClose", "function(response)", socket.getOnClose()).callback("onOpen", "function(response)", socket.getOnOpen()).callback("onReconnect", "function(response)", socket.getOnReconnect()).callback("onMessagePublished", "function(response)", socket.getOnMessagePublished()).callback("onTransportFailure", "function(response, request)", socket.getOnTransportFailure()).callback("onLocalMessage", "function(response)", socket.getOnLocalMessage());
        this.encodeClientBehaviors(context, socket);
        wb.finish();
    }
}

