/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.steps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.steps.Steps;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.ComponentTraversalUtils;

public class StepsRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Steps steps = (Steps)abstractMenu;
        String clientId = steps.getClientId(context);
        String styleClass = steps.getStyleClass();
        String containerClass = steps.isReadonly() ? "ui-steps ui-steps-readonly ui-widget ui-helper-clearfix" : "ui-steps ui-widget ui-helper-clearfix";
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        int activeIndex = steps.getActiveIndex();
        List elements = steps.getElements();
        writer.startElement("div", (UIComponent)steps);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (steps.getStyle() != null) {
            writer.writeAttribute("style", (Object)steps.getStyle(), "style");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        int i = 0;
        if (elements != null && !elements.isEmpty()) {
            for (MenuElement element : elements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                this.encodeItem(context, steps, (MenuItem)element, activeIndex, i);
                ++i;
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, Steps steps, MenuItem item, int activeIndex, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemClass = steps.isReadonly() ? (index == activeIndex ? "ui-steps-item ui-state-highlight ui-corner-all" : "ui-steps-item ui-state-default ui-state-disabled ui-corner-all") : (index == activeIndex ? "ui-steps-item ui-state-highlight ui-corner-all" : (index < activeIndex ? "ui-steps-item ui-state-default ui-corner-all" : "ui-steps-item ui-state-default ui-state-disabled ui-corner-all"));
        String containerStyle = item.getContainerStyle();
        String containerStyleClass = item.getContainerStyleClass();
        if (containerStyleClass != null) {
            itemClass = itemClass + " " + containerStyleClass;
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)itemClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        if (containerStyle != null) {
            writer.writeAttribute("style", (Object)containerStyle, null);
        }
        this.encodeMenuItem(context, steps, item, activeIndex, index);
        writer.endElement("li");
    }

    protected void encodeMenuItem(FacesContext context, Steps steps, MenuItem menuitem, int activeIndex, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        String style = menuitem.getStyle();
        String styleClass = this.getLinkStyleClass(menuitem);
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (this.shouldRenderId(menuitem)) {
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (steps.isReadonly() || menuitem.isDisabled() || activeIndex <= index) {
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"return false;", null);
        } else {
            String onclick = menuitem.getOnclick();
            if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
                String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
                writer.writeAttribute("href", (Object)targetURL, null);
                if (menuitem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                }
            } else {
                String command;
                writer.writeAttribute("href", (Object)"#", null);
                UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)steps);
                if (form == null) {
                    throw new FacesException("MenuItem must be inside a form element");
                }
                if (menuitem.isDynamic()) {
                    String menuClientId = steps.getClientId(context);
                    Map<String, List<String>> params = menuitem.getParams();
                    if (params == null) {
                        params = new LinkedHashMap<String, List<String>>();
                    }
                    ArrayList<String> idParams = new ArrayList<String>();
                    idParams.add(menuitem.getId());
                    params.put(menuClientId + "_menuid", idParams);
                    command = menuitem.isAjax() ? this.buildAjaxRequest(context, steps, (AjaxSource)((Object)menuitem), (UIComponent)form, params) : this.buildNonAjaxRequest(context, (UIComponent)steps, (UIComponent)form, menuClientId, params, true);
                } else {
                    command = menuitem.isAjax() ? this.buildAjaxRequest(context, (AjaxSource)((Object)menuitem), (UIComponent)form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
                }
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
        }
        writer.startElement("span", (UIComponent)steps);
        writer.writeAttribute("class", (Object)"ui-steps-number", null);
        writer.writeText((Object)(index + 1), null);
        writer.endElement("span");
        Object value = menuitem.getValue();
        if (value != null) {
            writer.startElement("span", (UIComponent)steps);
            writer.writeAttribute("class", (Object)"ui-steps-title", null);
            writer.writeText(value, null);
            writer.endElement("span");
        }
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
    }
}

