/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.texteditor;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.texteditor.TextEditor;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class TextEditorRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TextEditor editor = (TextEditor)component;
        String inputParam = editor.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(inputParam);
        if (value != null && value.equals("<br/>")) {
            value = "";
        }
        editor.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TextEditor editor = (TextEditor)component;
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext context, TextEditor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)editor);
        String inputId = clientId + "_input";
        String editorId = clientId + "_editor";
        UIComponent toolbar = editor.getFacet("toolbar");
        String style = editor.getStyle();
        String styleClass = editor.getStyleClass();
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        if (toolbar != null) {
            writer.startElement("div", (UIComponent)editor);
            writer.writeAttribute("id", (Object)(clientId + "_toolbar"), null);
            writer.writeAttribute("class", (Object)"ui-editor-toolbar", null);
            toolbar.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)editorId, null);
        if (valueToRender != null) {
            writer.write(valueToRender);
        }
        writer.endElement("div");
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.endElement("input");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, TextEditor editor) throws IOException {
        String clientId = editor.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("TextEditor", editor.resolveWidgetVar(), clientId).attr("readOnly", editor.isReadonly(), false).attr("placeholder", editor.getPlaceholder(), null).attr("height", editor.getHeight(), Integer.MIN_VALUE);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        TextEditor editor = (TextEditor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        return value;
    }
}

