/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.event.timeline.TimelineAddEvent;
import org.primefaces.event.timeline.TimelineDragDropEvent;
import org.primefaces.event.timeline.TimelineLazyLoadEvent;
import org.primefaces.event.timeline.TimelineModificationEvent;
import org.primefaces.event.timeline.TimelineRangeEvent;
import org.primefaces.event.timeline.TimelineSelectEvent;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineGroup;
import org.primefaces.model.timeline.TimelineModel;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.DateUtils;
import org.primefaces.visit.UIDataContextCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="timeline/timeline.css"), @ResourceDependency(library="primefaces", name="timeline/timeline.js")})
public class Timeline
extends UIComponentBase
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Timeline";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.TimelineRenderer";
    private static final Logger logger = Logger.getLogger(Timeline.class.getName());
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put("add", TimelineAddEvent.class);
            this.put("change", TimelineModificationEvent.class);
            this.put("changed", TimelineModificationEvent.class);
            this.put("edit", TimelineModificationEvent.class);
            this.put("delete", TimelineModificationEvent.class);
            this.put("select", TimelineSelectEvent.class);
            this.put("rangechange", TimelineRangeEvent.class);
            this.put("rangechanged", TimelineRangeEvent.class);
            this.put("lazyload", TimelineLazyLoadEvent.class);
            this.put("drop", TimelineDragDropEvent.class);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private String clientId = null;
    private StringBuilder idBuilder = new StringBuilder();
    private UIComponent parentComponent;

    public Timeline() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.var), null);
    }

    public void setVar(String _var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)_var);
    }

    public TimelineModel getValue() {
        return (TimelineModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(TimelineModel _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)_value);
    }

    public String getVarGroup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.varGroup), null);
    }

    public void setVarGroup(String _varGroup) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.varGroup), (Object)_varGroup);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object _locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), _locale);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object _timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), _timeZone);
    }

    public Object getBrowserTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.browserTimeZone), null);
    }

    public void setBrowserTimeZone(Object _browserTimeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.browserTimeZone), _browserTimeZone);
    }

    public String getHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height), (Object)"auto");
    }

    public void setHeight(String _height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)_height);
    }

    public int getMinHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHeight), (Object)0);
    }

    public void setMinHeight(int _minHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHeight), (Object)_minHeight);
    }

    public String getWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width), (Object)"100%");
    }

    public void setWidth(String _width) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)_width);
    }

    public boolean isResponsive() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.responsive), (Object)true);
    }

    public void setResponsive(boolean _responsive) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.responsive), (Object)_responsive);
    }

    public boolean isAxisOnTop() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.axisOnTop), (Object)false);
    }

    public void setAxisOnTop(boolean _axisOnTop) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.axisOnTop), (Object)_axisOnTop);
    }

    public int getDragAreaWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dragAreaWidth), (Object)10);
    }

    public void setDragAreaWidth(int _dragAreaWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dragAreaWidth), (Object)_dragAreaWidth);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
    }

    public boolean isSelectable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectable), (Object)true);
    }

    public void setSelectable(boolean _selectable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectable), (Object)_selectable);
    }

    public boolean isUnselectable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.unselectable), (Object)true);
    }

    public void setUnselectable(boolean _unselectable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.unselectable), (Object)_unselectable);
    }

    public boolean isZoomable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomable), (Object)true);
    }

    public void setZoomable(boolean _zoomable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomable), (Object)_zoomable);
    }

    public boolean isMoveable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.moveable), (Object)true);
    }

    public void setMoveable(boolean _moveable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.moveable), (Object)_moveable);
    }

    public Date getStart() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.start), null);
    }

    public void setStart(Date _start) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.start), (Object)_start);
    }

    public Date getEnd() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.end), null);
    }

    public void setEnd(Date _end) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.end), (Object)_end);
    }

    public Date getMin() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.min), null);
    }

    public void setMin(Date _min) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.min), (Object)_min);
    }

    public Date getMax() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.max), null);
    }

    public void setMax(Date _max) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.max), (Object)_max);
    }

    public Long getZoomMin() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomMin), (Object)10L);
    }

    public void setZoomMin(Long _zoomMin) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomMin), (Object)_zoomMin);
    }

    public Long getZoomMax() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomMax), (Object)315360000000000L);
    }

    public void setZoomMax(Long _zoomMax) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomMax), (Object)_zoomMax);
    }

    public Float getPreloadFactor() {
        return (Float)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.preloadFactor), (Object)Float.valueOf(0.0f));
    }

    public void setPreloadFactor(Float _preloadFactor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.preloadFactor), (Object)_preloadFactor);
    }

    public int getEventMargin() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventMargin), (Object)10);
    }

    public void setEventMargin(int _eventMargin) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventMargin), (Object)_eventMargin);
    }

    public int getEventMarginAxis() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventMarginAxis), (Object)10);
    }

    public void setEventMarginAxis(int _eventMarginAxis) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventMarginAxis), (Object)_eventMarginAxis);
    }

    public String getEventStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventStyle), (Object)"box");
    }

    public void setEventStyle(String _eventStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventStyle), (Object)_eventStyle);
    }

    public boolean isGroupsChangeable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsChangeable), (Object)true);
    }

    public void setGroupsChangeable(boolean _groupsChangeable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsChangeable), (Object)_groupsChangeable);
    }

    public boolean isGroupsOnRight() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsOnRight), (Object)false);
    }

    public void setGroupsOnRight(boolean _groupsOnRight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsOnRight), (Object)_groupsOnRight);
    }

    public boolean isGroupsOrder() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsOrder), (Object)true);
    }

    public void setGroupsOrder(boolean _groupsOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsOrder), (Object)_groupsOrder);
    }

    public String getGroupsWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsWidth), null);
    }

    public void setGroupsWidth(String _groupsWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsWidth), (Object)_groupsWidth);
    }

    public int getGroupMinHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupMinHeight), (Object)0);
    }

    public void setGroupMinHeight(int _groupMinHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupMinHeight), (Object)_groupMinHeight);
    }

    public boolean isSnapEvents() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.snapEvents), (Object)true);
    }

    public void setSnapEvents(boolean _snapEvents) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.snapEvents), (Object)_snapEvents);
    }

    public boolean isStackEvents() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stackEvents), (Object)true);
    }

    public void setStackEvents(boolean _stackEvents) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stackEvents), (Object)_stackEvents);
    }

    public boolean isShowCurrentTime() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCurrentTime), (Object)true);
    }

    public void setShowCurrentTime(boolean _showCurrentTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showCurrentTime), (Object)_showCurrentTime);
    }

    public boolean isShowMajorLabels() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMajorLabels), (Object)true);
    }

    public void setShowMajorLabels(boolean _showMajorLabels) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMajorLabels), (Object)_showMajorLabels);
    }

    public boolean isShowMinorLabels() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinorLabels), (Object)true);
    }

    public void setShowMinorLabels(boolean _showMinorLabels) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMinorLabels), (Object)_showMinorLabels);
    }

    public boolean isShowButtonNew() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showButtonNew), (Object)false);
    }

    public void setShowButtonNew(boolean _showButtonNew) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showButtonNew), (Object)_showButtonNew);
    }

    public boolean isShowNavigation() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNavigation), (Object)false);
    }

    public void setShowNavigation(boolean _showNavigation) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNavigation), (Object)_showNavigation);
    }

    public boolean isTimeChangeable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeChangeable), (Object)true);
    }

    public void setTimeChangeable(boolean _timeChangeable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeChangeable), (Object)_timeChangeable);
    }

    public String getDropHoverStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropHoverStyleClass), null);
    }

    public void setDropHoverStyleClass(String _dropHoverStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropHoverStyleClass), (Object)_dropHoverStyleClass);
    }

    public String getDropActiveStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropActiveStyleClass), null);
    }

    public void setDropActiveStyleClass(String _dropActiveStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropActiveStyleClass), (Object)_dropActiveStyleClass);
    }

    public String getDropAccept() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropAccept), null);
    }

    public void setDropAccept(String _dropAccept) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropAccept), (Object)_dropAccept);
    }

    public String getDropScope() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropScope), null);
    }

    public void setDropScope(String _dropScope) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropScope), (Object)_dropScope);
    }

    public boolean isAnimate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.animate), (Object)true);
    }

    public void setAnimate(boolean _animate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.animate), (Object)_animate);
    }

    public boolean isAnimateZoom() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.animateZoom), (Object)true);
    }

    public void setAnimateZoom(boolean _animateZoom) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.animateZoom), (Object)_animateZoom);
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("add".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineAddEvent te = new TimelineAddEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), this.getGroup((String)params.get(clientId + "_group")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("change".equals(eventName) || "changed".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                    TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                    TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                    clonedEvent.setStartDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")));
                    clonedEvent.setEndDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                    clonedEvent.setGroup(this.getGroup((String)params.get(clientId + "_group")));
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("edit".equals(eventName) || "delete".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setStartDate((Date)timelineEvent.getStartDate().clone());
                    clonedEvent.setEndDate(timelineEvent.getEndDate() != null ? (Date)timelineEvent.getEndDate().clone() : null);
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setGroup(timelineEvent.getGroup());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("select".equals(eventName)) {
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                TimelineSelectEvent te = new TimelineSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), timelineEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("rangechange".equals(eventName) || "rangechanged".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineRangeEvent te = new TimelineRangeEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("lazyload".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineLazyLoadEvent te = new TimelineLazyLoadEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateSecond")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateSecond")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("drop".equals(eventName)) {
                Object data = null;
                String dragId = (String)params.get(clientId + "_dragId");
                String uiDataId = (String)params.get(clientId + "_uiDataId");
                if (dragId != null && uiDataId != null) {
                    UIDataContextCallback contextCallback = new UIDataContextCallback(dragId);
                    context.getViewRoot().invokeOnComponent(context, uiDataId, (ContextCallback)contextCallback);
                    data = contextCallback.getData();
                }
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineDragDropEvent te = new TimelineDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), this.getGroup((String)params.get(clientId + "_group")), dragId, data);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
        }
        super.queueEvent(event);
    }

    private String getGroup(String groupParam) {
        int idxGroupOrder;
        List<TimelineGroup> groups = this.getValue().getGroups();
        if (groups == null || groupParam == null) {
            return groupParam;
        }
        int idx = groupParam.indexOf("</span>");
        if (idx > -1 && (idxGroupOrder = (groupParam = groupParam.substring(0, idx)).indexOf("#")) > -1) {
            String groupOrder = groupParam.substring(idxGroupOrder + 1);
            return groups.get(Integer.valueOf(groupOrder)).getId();
        }
        return groupParam;
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public UIComponent getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(UIComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getClientId(FacesContext context) {
        UIComponent namingContainer;
        if (this.clientId != null) {
            return this.clientId;
        }
        String id = this.getId();
        if (id == null) {
            UniqueIdVendor parentUniqueIdVendor = ComponentTraversalUtils.closestUniqueIdVendor((UIComponent)this);
            if (parentUniqueIdVendor == null) {
                UIViewRoot viewRoot = context.getViewRoot();
                if (viewRoot == null) throw new FacesException("Cannot create clientId for " + this.getClass().getCanonicalName());
                id = viewRoot.createUniqueId();
            } else {
                id = parentUniqueIdVendor.createUniqueId(context, null);
            }
            this.setId(id);
        }
        if (this.parentComponent != null && !(this.parentComponent instanceof UIForm)) {
            this.setParent(this.parentComponent);
        }
        if ((namingContainer = ComponentTraversalUtils.closestNamingContainer((UIComponent)this)) != null) {
            String containerClientId = namingContainer.getContainerClientId(context);
            if (containerClientId != null) {
                this.clientId = this.idBuilder.append(containerClientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(id).toString();
                this.idBuilder.setLength(0);
            } else {
                this.clientId = id;
            }
        } else {
            this.clientId = id;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer == null) return this.clientId;
        this.clientId = renderer.convertClientId(context, this.clientId);
        return this.clientId;
    }

    public void setId(String id) {
        super.setId(id);
        this.clientId = null;
    }

    @Override
    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        widgetVar,
        style,
        styleClass,
        var,
        value,
        varGroup,
        locale,
        timeZone,
        browserTimeZone,
        height,
        minHeight,
        width,
        responsive,
        axisOnTop,
        dragAreaWidth,
        editable,
        selectable,
        unselectable,
        zoomable,
        moveable,
        start,
        end,
        min,
        max,
        zoomMin,
        zoomMax,
        preloadFactor,
        eventMargin,
        eventMarginAxis,
        eventStyle,
        groupsChangeable,
        groupsOnRight,
        groupsOrder,
        groupsWidth,
        groupMinHeight,
        snapEvents,
        stackEvents,
        showCurrentTime,
        showMajorLabels,
        showMinorLabels,
        showButtonNew,
        showNavigation,
        timeChangeable,
        dropHoverStyleClass,
        dropActiveStyleClass,
        dropAccept,
        dropScope,
        animate,
        animateZoom;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

