/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITree;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class TreeTable
extends UITree
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder,
Pageable {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TreeTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.TreeTableRenderer";
    public static final String CONTAINER_CLASS = "ui-treetable ui-widget";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-treetable ui-treetable-resizable ui-widget";
    public static final String HEADER_CLASS = "ui-treetable-header ui-widget-header ui-corner-top";
    public static final String DATA_CLASS = "ui-treetable-data ui-widget-content";
    public static final String FOOTER_CLASS = "ui-treetable-footer ui-widget-header ui-corner-bottom";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String SORTABLE_COLUMN_HEADER_CLASS = "ui-state-default ui-sortable-column";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTED_ROW_CLASS = "ui-widget-content ui-state-highlight ui-selected";
    public static final String COLUMN_CONTENT_WRAPPER = "ui-tt-c";
    public static final String EXPAND_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
    public static final String COLLAPSE_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-treetable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-treetable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-treetable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-treetable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-treetable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-treetable-scrollable-footer-box";
    public static final String SELECTABLE_NODE_CLASS = "ui-treetable-selectable-node";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String INDENT_CLASS = "ui-treetable-indent";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-treetable-empty-message";
    public static final String PARTIAL_SELECTED_CLASS = "ui-treetable-partialselected";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String REFLOW_CLASS = "ui-treetable-reflow";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put("select", NodeSelectEvent.class);
            this.put("unselect", NodeUnselectEvent.class);
            this.put("expand", NodeExpandEvent.class);
            this.put("collapse", NodeCollapseEvent.class);
            this.put("colResize", ColumnResizeEvent.class);
            this.put("sort", SortEvent.class);
            this.put("rowEdit", RowEditEvent.class);
            this.put("rowEditInit", RowEditEvent.class);
            this.put("rowEditCancel", RowEditEvent.class);
            this.put("cellEdit", CellEditEvent.class);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private List<String> selectedRowKeys = new ArrayList<String>();
    private int columnsCount = -1;
    private UIColumn sortColumn;
    private List<UIColumn> columns;
    private Columns dynamicColumns;

    public TreeTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
    }

    public String getScrollHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), null);
    }

    public void setScrollHeight(String _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
    }

    public String getScrollWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), null);
    }

    public void setScrollWidth(String _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
    }

    public boolean isLiveResize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveResize), (Object)false);
    }

    public void setLiveResize(boolean _liveResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveResize), (Object)_liveResize);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
    }

    public boolean isNativeElements() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nativeElements), (Object)false);
    }

    public void setNativeElements(boolean _nativeElements) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nativeElements), (Object)_nativeElements);
    }

    public Object getDataLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dataLocale), null);
    }

    public void setDataLocale(Object _dataLocale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dataLocale), _dataLocale);
    }

    public boolean isCaseSensitiveSort() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)false);
    }

    public void setCaseSensitiveSort(boolean _caseSensitiveSort) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)_caseSensitiveSort);
    }

    public String getExpandMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandMode), (Object)"children");
    }

    public void setExpandMode(String _expandMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandMode), (Object)_expandMode);
    }

    public boolean isStickyHeader() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stickyHeader), (Object)false);
    }

    public void setStickyHeader(boolean _stickyHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stickyHeader), (Object)_stickyHeader);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
    }

    public String getEditMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editMode), (Object)"row");
    }

    public void setEditMode(String _editMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editMode), (Object)_editMode);
    }

    public boolean isEditingRow() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editingRow), (Object)false);
    }

    public void setEditingRow(boolean _editingRow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editingRow), (Object)_editingRow);
    }

    public String getCellSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cellSeparator), null);
    }

    public void setCellSeparator(String _cellSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cellSeparator), (Object)_cellSeparator);
    }

    public boolean isDisabledTextSelection() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledTextSelection), (Object)true);
    }

    public void setDisabledTextSelection(boolean _disabledTextSelection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledTextSelection), (Object)_disabledTextSelection);
    }

    public boolean isPaginator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginator), (Object)false);
    }

    public void setPaginator(boolean _paginator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginator), (Object)_paginator);
    }

    @Override
    public String getPaginatorTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorTemplate), (Object)"{FirstPageLink} {PreviousPageLink} {PageLinks} {NextPageLink} {LastPageLink} {RowsPerPageDropdown}");
    }

    public void setPaginatorTemplate(String _paginatorTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorTemplate), (Object)_paginatorTemplate);
    }

    @Override
    public String getRowsPerPageTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), null);
    }

    public void setRowsPerPageTemplate(String _rowsPerPageTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), (Object)_rowsPerPageTemplate);
    }

    @Override
    public String getRowsPerPageLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowsPerPageLabel), null);
    }

    public void setRowsPerPageLabel(String _rowsPerPageLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowsPerPageLabel), (Object)_rowsPerPageLabel);
    }

    @Override
    public String getCurrentPageReportTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentPageReportTemplate), null);
    }

    public void setCurrentPageReportTemplate(String _currentPageReportTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentPageReportTemplate), (Object)_currentPageReportTemplate);
    }

    @Override
    public int getPageLinks() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pageLinks), (Object)10);
    }

    public void setPageLinks(int _pageLinks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pageLinks), (Object)_pageLinks);
    }

    @Override
    public String getPaginatorPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)"both");
    }

    public void setPaginatorPosition(String _paginatorPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)_paginatorPosition);
    }

    @Override
    public boolean isPaginatorAlwaysVisible() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)true);
    }

    public void setPaginatorAlwaysVisible(boolean _paginatorAlwaysVisible) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)_paginatorAlwaysVisible);
    }

    @Override
    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)0);
    }

    public void setRows(int _rows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), (Object)_rows);
    }

    @Override
    public int getFirst() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.first), (Object)0);
    }

    public void setFirst(int _first) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.first), (Object)_first);
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public boolean isSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelection");
    }

    public boolean isSortRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_sorting");
    }

    public boolean isPaginationRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pagination");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isCellEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellInfo");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("expand")) {
                String nodeKey = (String)params.get(clientId + "_expand");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("collapse")) {
                String nodeKey = (String)params.get(clientId + "_collapse");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                node.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("select")) {
                String nodeKey = (String)params.get(clientId + "_instantSelection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("unselect")) {
                String nodeKey = (String)params.get(clientId + "_instantUnselection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("sort")) {
                SortOrder order = SortOrder.valueOf((String)params.get(clientId + "_sortDir"));
                UIColumn sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order, 0);
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                String nodeKey = (String)params.get(clientId + "_rowEditIndex");
                this.setRowKey(nodeKey);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("cellEdit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                String rowKey = cellInfo[0];
                int cellIndex = Integer.parseInt(cellInfo[1]);
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), column, rowKey);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            }
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        FacesContext context = this.getFacesContext();
        ColumnGroup headerGroup = this.getColumnGroup("header");
        for (UIComponent row : headerGroup.getChildren()) {
            for (UIComponent col : row.getChildren()) {
                if (!col.getClientId(context).equals(clientId)) continue;
                return (UIColumn)col;
            }
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            Column column;
            if (!(child instanceof Column) || !child.isRendered() || (column = (Column)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expand") != null || params.get(clientId + "_collapse") != null;
    }

    public boolean isResizeRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_colResize") != null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof Column)) continue;
                ++this.columnsCount;
            }
        }
        return this.columnsCount;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    public boolean isCheckboxSelection() {
        String selectionMode = this.getSelectionMode();
        return selectionMode != null && selectionMode.equals("checkbox");
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
    }

    public UIColumn getSortColumn() {
        return this.sortColumn;
    }

    public void clearDefaultSorted() {
        this.getStateHelper().remove((Serializable)((Object)"defaultSorted"));
    }

    public void setDefaultSorted() {
        this.getStateHelper().put((Serializable)((Object)"defaultSorted"), (Object)"defaultSorted");
    }

    public boolean isDefaultSorted() {
        return this.getStateHelper().get((Serializable)((Object)"defaultSorted")) != null;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        Object userLocale = this.getDataLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                return ComponentUtils.toLocale((String)userLocale);
            }
            if (userLocale instanceof Locale) {
                return (Locale)userLocale;
            }
            throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for datatable:" + this.getClientId(context));
        }
        return context.getViewRoot().getLocale();
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    public Object saveState(FacesContext context) {
        if (this.dynamicColumns != null) {
            this.dynamicColumns.setRowIndex(-1);
        }
        return super.saveState(context);
    }

    @Override
    protected void validateSelection(FacesContext context) {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null && this.isRequired()) {
            boolean isValueBlank;
            Object selection = this.getLocalSelectedNodes();
            boolean bl = selectionMode.equalsIgnoreCase("single") ? selection == null : (isValueBlank = ((TreeNode[])selection).length == 0);
            if (isValueBlank) {
                super.updateSelection(context);
            }
        }
        super.validateSelection(context);
    }

    @Override
    public int getRowCount() {
        TreeNode root = this.getValue();
        if (root == null) {
            return -1;
        }
        List<TreeNode> children = root.getChildren();
        return children == null ? -1 : children.size();
    }

    @Override
    public int getPage() {
        if (this.getRowCount() > 0) {
            int rows = this.getRowsToRender();
            if (rows > 0) {
                int first = this.getFirst();
                return first / rows;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getRowsToRender() {
        int rows = this.getRows();
        return rows == 0 ? this.getRowCount() : rows;
    }

    @Override
    public int getPageCount() {
        return (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)this.getRowsToRender());
    }

    public UIComponent getHeader() {
        return this.getFacet("header");
    }

    public UIComponent getFooter() {
        return this.getFacet("footer");
    }

    public void calculateFirst() {
        int rows = this.getRows();
        if (rows > 0) {
            int first = this.getFirst();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && first >= rowCount) {
                int numberOfPages = (int)Math.ceil((double)rowCount * 1.0 / (double)rows);
                this.setFirst(Math.max((numberOfPages - 1) * rows, 0));
            }
        }
    }

    public void updatePaginationData(FacesContext context) {
        String componentClientId = this.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        ELContext elContext = context.getELContext();
        String firstParam = (String)params.get(componentClientId + "_first");
        String rowsParam = (String)params.get(componentClientId + "_rows");
        this.setFirst(Integer.valueOf(firstParam));
        this.setRows(Integer.valueOf(rowsParam));
        ValueExpression firstVe = this.getValueExpression("first");
        ValueExpression rowsVe = this.getValueExpression("rows");
        if (firstVe != null && !firstVe.isReadOnly(elContext)) {
            firstVe.setValue(context.getELContext(), (Object)this.getFirst());
        }
        if (rowsVe != null && !rowsVe.isReadOnly(elContext)) {
            rowsVe.setValue(context.getELContext(), (Object)this.getRows());
        }
    }

    @Override
    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar(this.getFacesContext(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        widgetVar,
        style,
        styleClass,
        scrollable,
        scrollHeight,
        scrollWidth,
        tableStyle,
        tableStyleClass,
        emptyMessage,
        resizableColumns,
        rowStyleClass,
        liveResize,
        sortBy,
        sortOrder,
        sortFunction,
        nativeElements,
        dataLocale,
        caseSensitiveSort,
        expandMode,
        stickyHeader,
        editable,
        editMode,
        editingRow,
        cellSeparator,
        disabledTextSelection,
        paginator,
        paginatorTemplate,
        rowsPerPageTemplate,
        rowsPerPageLabel,
        currentPageReportTemplate,
        pageLinks,
        paginatorPosition,
        paginatorAlwaysVisible,
        rows,
        first;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

